/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.ipc;

import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class SharedEntry {
    public static final int MAX_SIZE = 1024;
    public static final byte VALUE_TYPE_INT = 1;
    public static final byte VALUE_TYPE_LONG = 2;
    public static final byte VALUE_TYPE_FLOAT = 3;
    public static final byte VALUE_TYPE_BOOLEAN = 4;
    public static final byte VALUE_TYPE_STRING = 5;
    public static final byte VALUE_TYPE_INT_ARRAY = 6;
    private final int mPosition;
    private final String mKey;
    private final int mValuePosition;

    SharedEntry(ByteBuffer byteBuffer, int position) throws IllegalArgumentException {
        this.mPosition = position;
        byteBuffer.position(this.mPosition);
        short keyLength = byteBuffer.getShort();
        if (keyLength == 0) {
            throw new IllegalArgumentException("This position is not valid");
        }
        byte[] bytes = new byte[keyLength];
        byteBuffer.get(bytes);
        this.mKey = new String(bytes);
        this.mValuePosition = this.mPosition + 2 + keyLength;
    }

    SharedEntry(ByteBuffer byteBuffer, int position, String key) {
        this.mPosition = position;
        this.mKey = key;
        byteBuffer.position(this.mPosition);
        short keyLength = (short)this.mKey.length();
        byteBuffer.putShort(keyLength);
        byteBuffer.put(this.mKey.getBytes());
        this.mValuePosition = this.mPosition + 2 + keyLength;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public String getKey() {
        return this.mKey;
    }

    @Nullable
    public Object getValue(ByteBuffer byteBuffer) {
        byteBuffer.position(this.mValuePosition);
        byte valueType = byteBuffer.get();
        int valueLength = byteBuffer.getShort();
        switch (valueType) {
            case 1: {
                if (valueLength != 4) break;
                return byteBuffer.getInt();
            }
            case 2: {
                if (valueLength != 8) break;
                return byteBuffer.getLong();
            }
            case 3: {
                if (valueLength != 4) break;
                return Float.valueOf(byteBuffer.getFloat());
            }
            case 4: {
                int size = 8;
                if (valueLength != 8 / size) break;
                return byteBuffer.get() == 1;
            }
            case 5: {
                if (valueLength <= 0) break;
                byte[] bytes = new byte[valueLength];
                byteBuffer.get(bytes);
                return new String(bytes);
            }
            case 6: {
                if (valueLength <= 0) break;
                ArrayList<Integer> array = new ArrayList<Integer>();
                for (int i = 0; i < valueLength; ++i) {
                    array.add(byteBuffer.getInt());
                }
                return array;
            }
        }
        return null;
    }

    public void putIntArray(ByteBuffer byteBuffer, List<Integer> values) {
        byteBuffer.position(this.mValuePosition);
        byteBuffer.put((byte)6);
        if (values.size() * 4 > 1024 - (this.mValuePosition - this.mPosition)) {
            throw new IllegalArgumentException("value is too long, value.length() = " + values.size());
        }
        byteBuffer.putShort((short)values.size());
        for (int value : values) {
            byteBuffer.putInt(value);
        }
    }

    public void putString(ByteBuffer byteBuffer, @Nullable String value) throws IllegalArgumentException {
        byte[] valueBytes;
        short valueLength;
        byteBuffer.position(this.mValuePosition);
        byteBuffer.put((byte)5);
        if (value == null) {
            value = "";
        }
        short s = valueLength = (valueBytes = value.getBytes()) == null ? (short)0 : (short)valueBytes.length;
        if (valueLength > 1024 - (this.mValuePosition - this.mPosition)) {
            throw new IllegalArgumentException("value is too long, value.length() = " + value.length());
        }
        byteBuffer.putShort(valueLength);
        if (valueLength > 0) {
            byteBuffer.put(valueBytes);
        }
    }

    public void putInt(ByteBuffer byteBuffer, int value) {
        byteBuffer.position(this.mValuePosition);
        byteBuffer.put((byte)1);
        byteBuffer.putShort((short)4);
        byteBuffer.putInt(value);
    }

    public void putLong(ByteBuffer byteBuffer, long value) {
        byteBuffer.position(this.mValuePosition);
        byteBuffer.put((byte)2);
        byteBuffer.putShort((short)8);
        byteBuffer.putLong(value);
    }

    public void putFloat(ByteBuffer byteBuffer, float value) {
        byteBuffer.position(this.mValuePosition);
        byteBuffer.put((byte)3);
        byteBuffer.putShort((short)4);
        byteBuffer.putFloat(value);
    }

    public void putBoolean(ByteBuffer byteBuffer, boolean value) {
        int size = 8;
        byteBuffer.position(this.mValuePosition);
        byteBuffer.put((byte)4);
        byteBuffer.putShort((short)(8 / size));
        byteBuffer.put((byte)(value ? 1 : 0));
    }

    public void putObject(ByteBuffer byteBuffer, int valueType, Object value) {
        switch (valueType) {
            case 1: {
                this.putInt(byteBuffer, (Integer)value);
                break;
            }
            case 2: {
                this.putLong(byteBuffer, (Long)value);
                break;
            }
            case 3: {
                this.putFloat(byteBuffer, ((Float)value).floatValue());
                break;
            }
            case 4: {
                this.putBoolean(byteBuffer, (Boolean)value);
                break;
            }
            case 5: {
                this.putString(byteBuffer, (String)value);
                break;
            }
            case 6: {
                this.putIntArray(byteBuffer, (List)value);
                break;
            }
        }
    }
}

