/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.ipc;

import android.content.Context;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class ProcessLock {
    private static final String TAG = "ProcessLock";
    private final Context mContext;
    private final String mName;
    private FileOutputStream mOutputStream;
    private FileChannel mFileChannel;
    private FileLock mFileLock;

    public ProcessLock(Context context, String name) {
        this.mContext = context;
        this.mName = name + ".lock";
    }

    private FileLock getFileLock() {
        if (this.mFileLock == null) {
            try {
                if (this.mOutputStream == null || this.mFileChannel == null) {
                    this.mOutputStream = this.mContext.openFileOutput(this.mName, 0);
                    this.mFileChannel = this.mOutputStream.getChannel();
                }
                this.mFileLock = this.mFileChannel.tryLock();
            }
            catch (IOException e) {
                return null;
            }
            catch (OverlappingFileLockException e) {
                return null;
            }
        }
        return this.mFileLock;
    }

    private void internalRelease() throws IOException {
        try {
            if (this.mFileLock != null && this.mFileLock.isValid()) {
                this.mFileLock.release();
            }
        }
        finally {
            try {
                if (this.mFileChannel != null) {
                    this.mFileChannel.close();
                }
            }
            finally {
                if (this.mOutputStream != null) {
                    this.mOutputStream.close();
                }
            }
        }
    }

    public void lockedRun(Runnable runnable) {
        if (this.mFileLock == null) {
            try {
                if (this.mOutputStream == null || this.mFileChannel == null) {
                    this.mOutputStream = this.mContext.openFileOutput(this.mName, 0);
                    this.mFileChannel = this.mOutputStream.getChannel();
                }
                this.mFileLock = this.mFileChannel.lock();
                runnable.run();
            }
            catch (Exception exception) {
            }
            finally {
                this.release();
            }
        }
    }

    public void release() {
        try {
            this.internalRelease();
        }
        catch (IOException iOException) {
        }
        finally {
            this.mOutputStream = null;
            this.mFileChannel = null;
            this.mFileLock = null;
        }
    }

    public boolean isAcquired() {
        FileLock fileLock = this.getFileLock();
        return fileLock != null && fileLock.isValid();
    }
}

