/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.ipc;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.ipc.EventSequenceId;
import com.growingio.android.sdk.track.ipc.IDataSharer;
import com.growingio.android.sdk.track.ipc.MultiProcessDataSharer;
import com.growingio.android.sdk.track.ipc.ProcessLock;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import com.growingio.android.sdk.track.providers.SessionProvider;
import com.growingio.android.sdk.track.utils.SystemUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PersistentDataProvider {
    private static final String TAG = "PersistentDataProvider";
    private static final String SHARER_NAME = "PersistentSharerDataProvider";
    private static final int SHARER_MAX_SIZE = 50;
    private static final String KEY_TYPE_GLOBAL = "TYPE_GLOBAL";
    private static final String KEY_LOGIN_USER_KEY = "LOGIN_USER_KEY";
    private static final String KEY_LOGIN_USER_ID = "LOGIN_USER_ID";
    private static final String KEY_DEVICE_ID = "DEVICE_ID";
    private static final String KEY_SESSION_ID = "SESSION_ID";
    private static final String KEY_ALIVE_PID = "ALIVE_PID";
    private static final String KEY_LATEST_NON_NULL_USER_ID = "LATEST_NON_NULL_USER_ID";
    private static final String KEY_LATEST_PAUSE_TIME = "LATEST_PAUSE_TIME";
    private static final String KEY_ACTIVITY_COUNT = "ACTIVITY_COUNT";
    private static final String KEY_SEND_VISIT_AFTER_REFRESH_SESSION_ID = "SEND_VISIT_AFTER_REFRESH_SESSION_ID";
    private final IDataSharer mDataSharer;
    private final ProcessLock mProcessLock;
    private final Context mContext = TrackerContext.get().getApplicationContext();

    private PersistentDataProvider() {
        this.mDataSharer = new MultiProcessDataSharer(this.mContext, SHARER_NAME, 50);
        this.mProcessLock = new ProcessLock(this.mContext, PersistentDataProvider.class.getName());
    }

    public static PersistentDataProvider get() {
        return SingleInstance.INSTANCE;
    }

    public void start() {
        this.repairPid();
    }

    public EventSequenceId getAndIncrement(String eventType) {
        long globalId = this.mDataSharer.getAndIncrementLong(KEY_TYPE_GLOBAL, 1L);
        long eventTypeId = this.mDataSharer.getAndIncrementLong(eventType, 1L);
        return new EventSequenceId(globalId, eventTypeId);
    }

    public String getSessionId() {
        return this.mDataSharer.getString(KEY_SESSION_ID, "");
    }

    public void setSessionId(String sessionId) {
        this.mDataSharer.putString(KEY_SESSION_ID, sessionId);
    }

    public String getDeviceId() {
        return this.mDataSharer.getString(KEY_DEVICE_ID, "");
    }

    public void setDeviceId(@NonNull String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            return;
        }
        this.mDataSharer.putString(KEY_DEVICE_ID, deviceId);
    }

    public String getLoginUserKey() {
        return this.mDataSharer.getString(KEY_LOGIN_USER_KEY, "");
    }

    public String getLoginUserId() {
        return this.mDataSharer.getString(KEY_LOGIN_USER_ID, "");
    }

    public void setLoginUserIdAndUserKey(@Nullable String userId, @Nullable String userKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_LOGIN_USER_ID, userId);
        map.put(KEY_LOGIN_USER_KEY, userKey);
        this.mDataSharer.putMultiString(map);
    }

    public String getLatestNonNullUserId() {
        return this.mDataSharer.getString(KEY_LATEST_NON_NULL_USER_ID, "");
    }

    public void setLatestNonNullUserId(@Nullable String latestNonNullUserId) {
        this.mDataSharer.putString(KEY_LATEST_NON_NULL_USER_ID, latestNonNullUserId);
    }

    public long getLatestPauseTime() {
        return this.mDataSharer.getLong(KEY_LATEST_PAUSE_TIME, 0L);
    }

    public void setLatestPauseTime(long latestPauseTime) {
        this.mDataSharer.putLong(KEY_LATEST_PAUSE_TIME, latestPauseTime);
    }

    public int getActivityCount() {
        return this.mDataSharer.getInt(KEY_ACTIVITY_COUNT, 0);
    }

    public void setActivityCount(int activityCount) {
        this.mDataSharer.putInt(KEY_ACTIVITY_COUNT, activityCount);
    }

    public void addActivityCount() {
        this.mDataSharer.getAndIncrementInt(KEY_ACTIVITY_COUNT, 0);
    }

    public void delActivityCount() {
        this.mDataSharer.getAndDecrementInt(KEY_ACTIVITY_COUNT, 0);
    }

    public boolean isSendVisitAfterRefreshSessionId() {
        return this.mDataSharer.getBoolean(KEY_SEND_VISIT_AFTER_REFRESH_SESSION_ID, false);
    }

    public void setSendVisitAfterRefreshSessionId(boolean sendVisitAfterRefreshSessionId) {
        this.mDataSharer.putBoolean(KEY_SEND_VISIT_AFTER_REFRESH_SESSION_ID, sendVisitAfterRefreshSessionId);
    }

    public void putString(String key, @Nullable String value) {
        this.mDataSharer.putString(key, value);
    }

    @Nullable
    public String getString(String key, String defValue) {
        return this.mDataSharer.getString(key, defValue);
    }

    private void repairPid() {
        this.mProcessLock.lockedRun(() -> {
            boolean isFirstProcess = false;
            if (ConfigurationProvider.core().isRequireAppProcessesEnabled() && ConfigurationProvider.core().isDataCollectionEnabled()) {
                ArrayList<Integer> alivePid = new ArrayList<Integer>();
                Set<Integer> runningProcess = this.getRunningProcess(this.mContext);
                for (int pid : this.getAlivePid()) {
                    if (!runningProcess.contains(pid)) continue;
                    alivePid.add(pid);
                }
                if (alivePid.isEmpty()) {
                    isFirstProcess = true;
                }
                alivePid.add(Process.myPid());
                this.putAlivePid(alivePid);
            } else {
                isFirstProcess = SystemUtil.isMainProcess(this.mContext);
                if (isFirstProcess) {
                    this.putAlivePid(new ArrayList<Integer>(Process.myPid()));
                }
            }
            if (isFirstProcess) {
                this.setActivityCount(0);
                this.setLatestPauseTime(System.currentTimeMillis());
                this.setLatestNonNullUserId(this.getLoginUserId());
                SessionProvider.get().refreshSessionId();
                SessionProvider.get().generateVisit();
            }
        });
    }

    private List<Integer> getAlivePid() {
        return this.mDataSharer.getIntArray(KEY_ALIVE_PID, new ArrayList<Integer>());
    }

    private void putAlivePid(List<Integer> value) {
        this.mDataSharer.putIntArray(KEY_ALIVE_PID, value);
    }

    private Set<Integer> getRunningProcess(Context context) {
        HashSet<Integer> myRunningProcess = new HashSet<Integer>();
        try {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            List runningAppProcesses = manager.getRunningAppProcesses();
            int myUid = Process.myUid();
            for (ActivityManager.RunningAppProcessInfo info : runningAppProcesses) {
                if (myUid != info.uid) continue;
                myRunningProcess.add(info.pid);
            }
        }
        catch (Throwable e) {
            Logger.e(TAG, e.getMessage(), e);
        }
        return myRunningProcess;
    }

    private static class SingleInstance {
        private static final PersistentDataProvider INSTANCE = new PersistentDataProvider();

        private SingleInstance() {
        }
    }
}

