/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.ipc;

import android.content.Context;
import androidx.annotation.Nullable;
import com.growingio.android.sdk.track.ipc.IDataSharer;
import com.growingio.android.sdk.track.ipc.SharedEntry;
import com.growingio.android.sdk.track.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiProcessDataSharer
implements IDataSharer {
    private static final String TAG = "MultiProcessDataSharer";
    private final Context mContext;
    private final String mName;
    private final int mMaxSize;
    private volatile boolean mLoaded;
    private MappedByteBuffer mMappedByteBuffer;
    private RandomAccessFile randomAccessFile;
    private FileChannel mFileChannel;
    private final Map<String, SharedEntry> mSharedEntries = new HashMap<String, SharedEntry>();
    private int mCurrentPosition = 0;

    public MultiProcessDataSharer(Context context, String name, int maxSize) {
        this.mContext = context;
        this.mName = name + ".shared";
        this.mMaxSize = maxSize;
        this.mLoaded = false;
        this.startLoadFromDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadFromDisk() {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.mLoaded = false;
        }
        new Thread("MultiProcessDataSharer-load"){

            @Override
            public void run() {
                MultiProcessDataSharer.this.loadFromDisk();
            }
        }.start();
    }

    private synchronized void awaitLoadedLocked() {
        while (!this.mLoaded) {
            try {
                Logger.d(TAG, "awaitLoadedLocked", new Object[0]);
                this.wait();
                Logger.d(TAG, "awaitLoadedLocked end", new Object[0]);
            }
            catch (InterruptedException e) {
                Logger.e(TAG, e, "awaitLoadedLocked interrupted", new Object[0]);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromDisk() {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            Logger.d(TAG, "loadFromDisk mLoaded is " + this.mLoaded, new Object[0]);
            if (this.mLoaded) {
                return;
            }
            File file = this.mContext.getFileStreamPath(this.mName);
            try {
                this.randomAccessFile = new RandomAccessFile(file, "rw");
                this.mFileChannel = this.randomAccessFile.getChannel();
                this.mMappedByteBuffer = this.mFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, (long)this.mMaxSize * 1024L);
                this.incrementLoadFromDisk();
            }
            catch (IOException e) {
                Logger.e(TAG, e);
            }
            Logger.d(TAG, "loadFromDisk successfully ", new Object[0]);
            this.mLoaded = true;
            this.notifyAll();
        }
    }

    private void lockedRun(Runnable run) {
        this.lockedRun(run, 0L, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockedRun(Runnable run, long position, long size) {
        FileLock lock = null;
        try {
            lock = this.mFileChannel.lock(position, size, false);
            run.run();
        }
        catch (IOException e) {
            Logger.e(TAG, e);
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    Logger.e(TAG, e);
                }
            }
        }
    }

    private void incrementLoadFromDisk() {
        int surplus = this.mMaxSize - this.mSharedEntries.size();
        for (int i = 0; i < surplus; ++i) {
            try {
                SharedEntry sharedEntry = new SharedEntry(this.mMappedByteBuffer, this.mCurrentPosition);
                this.mSharedEntries.put(sharedEntry.getKey(), sharedEntry);
                this.mCurrentPosition += 1024;
                continue;
            }
            catch (IllegalArgumentException e) {
                break;
            }
        }
    }

    private void incrementPutValue(final String key, final int valueType, final Object value) {
        this.lockedRun(new Runnable(){

            @Override
            public void run() {
                MultiProcessDataSharer.this.incrementLoadFromDisk();
                SharedEntry entry = (SharedEntry)MultiProcessDataSharer.this.mSharedEntries.get(key);
                if (entry == null) {
                    entry = new SharedEntry(MultiProcessDataSharer.this.mMappedByteBuffer, MultiProcessDataSharer.this.mCurrentPosition, key);
                    MultiProcessDataSharer.this.mSharedEntries.put(key, entry);
                }
                entry.putObject(MultiProcessDataSharer.this.mMappedByteBuffer, valueType, value);
            }
        });
    }

    private Object incrementGetValue(final String key) {
        final Object[] result = new Object[]{null};
        this.lockedRun(new Runnable(){

            @Override
            public void run() {
                MultiProcessDataSharer.this.incrementLoadFromDisk();
                SharedEntry entry = (SharedEntry)MultiProcessDataSharer.this.mSharedEntries.get(key);
                if (entry != null) {
                    result[0] = entry.getValue(MultiProcessDataSharer.this.mMappedByteBuffer);
                }
            }
        });
        return result[0];
    }

    private Object getValue(String key) {
        SharedEntry entry = this.mSharedEntries.get(key);
        if (entry != null) {
            final Object[] result = new Object[1];
            final SharedEntry finalEntry = entry;
            this.lockedRun(new Runnable(){

                @Override
                public void run() {
                    result[0] = finalEntry.getValue(MultiProcessDataSharer.this.mMappedByteBuffer);
                }
            }, entry.getPosition(), 1024L);
            return result[0];
        }
        return this.incrementGetValue(key);
    }

    private void putValue(String key, final int valueType, final Object value) {
        final SharedEntry entry = this.mSharedEntries.get(key);
        if (entry != null) {
            this.lockedRun(new Runnable(){

                @Override
                public void run() {
                    entry.putObject(MultiProcessDataSharer.this.mMappedByteBuffer, valueType, value);
                }
            }, entry.getPosition(), 1024L);
        } else {
            this.incrementPutValue(key, valueType, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getString(String key, @Nullable String defValue) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            String value = (String)this.getValue(key);
            return value != null ? value : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String key, int defValue) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            Integer value = (Integer)this.getValue(key);
            return value != null ? value : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String key, long defValue) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            Long value = (Long)this.getValue(key);
            return value != null ? value : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String key, float defValue) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            Float value = (Float)this.getValue(key);
            return value != null ? value.floatValue() : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String key, boolean defValue) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            Boolean value = (Boolean)this.getValue(key);
            return value != null ? value : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getIntArray(String key, List<Integer> defValue) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            List<Integer> value = (List<Integer>)this.getValue(key);
            return value != null ? value : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putString(String key, @Nullable String value) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            this.putValue(key, 5, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putMultiString(final Map<String, String> values) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            this.lockedRun(new Runnable(){

                @Override
                public void run() {
                    if (values != null) {
                        for (Map.Entry value : values.entrySet()) {
                            SharedEntry entry = (SharedEntry)MultiProcessDataSharer.this.mSharedEntries.get(value.getKey());
                            if (entry == null) {
                                MultiProcessDataSharer.this.incrementLoadFromDisk();
                                entry = (SharedEntry)MultiProcessDataSharer.this.mSharedEntries.get(value.getKey());
                                if (entry == null) {
                                    entry = new SharedEntry(MultiProcessDataSharer.this.mMappedByteBuffer, MultiProcessDataSharer.this.mCurrentPosition, (String)value.getKey());
                                    MultiProcessDataSharer.this.mSharedEntries.put(value.getKey(), entry);
                                }
                            }
                            entry.putObject(MultiProcessDataSharer.this.mMappedByteBuffer, 5, value.getValue());
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putInt(String key, int value) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            this.putValue(key, 1, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLong(String key, long value) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            this.putValue(key, 2, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFloat(String key, float value) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            this.putValue(key, 3, Float.valueOf(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putBoolean(String key, boolean value) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            this.putValue(key, 4, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putIntArray(String key, List<Integer> value) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            this.awaitLoadedLocked();
            this.putValue(key, 6, value);
        }
    }

    @Override
    public long getAndIncrementLong(String key, long startValue) {
        return this.getAndAddLong(key, 1L, startValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndAddLong(String key, final long delta, final long startValue) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            Logger.d(TAG, "getAndAddLong: key = " + key + ", delta = " + delta + ", startValue = " + startValue, new Object[0]);
            this.awaitLoadedLocked();
            final long[] result = new long[1];
            final SharedEntry entry = this.mSharedEntries.get(key);
            if (entry != null) {
                this.lockedRun(new Runnable(){

                    @Override
                    public void run() {
                        Long value = (Long)entry.getValue(MultiProcessDataSharer.this.mMappedByteBuffer);
                        result[0] = (value != null ? value : startValue) + delta;
                        entry.putLong(MultiProcessDataSharer.this.mMappedByteBuffer, result[0]);
                    }
                }, entry.getPosition(), 1024L);
                Logger.d(TAG, "getAndAddLong: result = " + result[0], new Object[0]);
                return result[0];
            }
            this.putValue(key, 2, startValue);
            Logger.d(TAG, "getAndAddLong: return startValue", new Object[0]);
            return startValue;
        }
    }

    @Override
    public int getAndIncrementInt(String key, int startValue) {
        return this.getAndAddInt(key, 1, startValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAndAddInt(String key, final int delta, final int startValue) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            Logger.d(TAG, "getAndAddInt: key = " + key + ", delta = " + delta + ", startValue = " + startValue, new Object[0]);
            this.awaitLoadedLocked();
            final int[] result = new int[1];
            final SharedEntry entry = this.mSharedEntries.get(key);
            if (entry != null) {
                this.lockedRun(new Runnable(){

                    @Override
                    public void run() {
                        Integer value = (Integer)entry.getValue(MultiProcessDataSharer.this.mMappedByteBuffer);
                        result[0] = (value != null ? value : startValue) + delta;
                        entry.putInt(MultiProcessDataSharer.this.mMappedByteBuffer, result[0]);
                    }
                }, entry.getPosition(), 1024L);
                Logger.d(TAG, "getAndAddInt: result = " + result[0], new Object[0]);
                return result[0];
            }
            this.putValue(key, 1, startValue);
            Logger.d(TAG, "getAndAddInt: return startValue", new Object[0]);
            return startValue;
        }
    }

    @Override
    public int getAndDecrementInt(String key, int startValue) {
        return this.getAndDelInt(key, 1, startValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAndDelInt(String key, final int delta, final int startValue) {
        MultiProcessDataSharer multiProcessDataSharer = this;
        synchronized (multiProcessDataSharer) {
            Logger.d(TAG, "getAndDelInt: key = " + key + ", delta = " + delta + ", startValue = " + startValue, new Object[0]);
            this.awaitLoadedLocked();
            final int[] result = new int[1];
            final SharedEntry entry = this.mSharedEntries.get(key);
            if (entry != null) {
                this.lockedRun(new Runnable(){

                    @Override
                    public void run() {
                        Integer value = (Integer)entry.getValue(MultiProcessDataSharer.this.mMappedByteBuffer);
                        result[0] = (value != null ? value : startValue) - delta;
                        entry.putInt(MultiProcessDataSharer.this.mMappedByteBuffer, result[0]);
                    }
                }, entry.getPosition(), 1024L);
                Logger.d(TAG, "getAndDelInt: result = " + result[0], new Object[0]);
                return result[0];
            }
            this.putValue(key, 1, startValue);
            Logger.d(TAG, "getAndDelInt: return startValue", new Object[0]);
            return startValue;
        }
    }
}

