/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventUrl {
    private final String mHost;
    private final Map<String, String> mHeaders = new HashMap<String, String>();
    private final List<String> mPaths = new ArrayList<String>();
    private final Map<String, String> mParams = new HashMap<String, String>();
    private byte[] mBodyData;
    private final long mTime;
    private String mMediaType = "application/json";

    public EventUrl(String host, long time) {
        this.mHost = host;
        this.mTime = time;
    }

    public EventUrl addPath(String path) {
        this.mPaths.add(path);
        return this;
    }

    public EventUrl addParam(String key, String param) {
        this.mParams.put(key, param);
        return this;
    }

    public EventUrl addHeader(String key, String value) {
        this.mHeaders.put(key, value);
        return this;
    }

    public String getMediaType() {
        return this.mMediaType;
    }

    public byte[] getRequestBody() {
        return this.mBodyData;
    }

    public long getTime() {
        return this.mTime;
    }

    public EventUrl setBodyData(byte[] mBodyData) {
        this.mBodyData = mBodyData;
        return this;
    }

    public EventUrl setMediaType(String mMediaType) {
        this.mMediaType = mMediaType;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public String toUrl() {
        StringBuilder urlBuilder = new StringBuilder(this.mHost);
        for (String path : this.mPaths) {
            if (urlBuilder.charAt(urlBuilder.length() - 1) != '/') {
                urlBuilder.append("/");
            }
            urlBuilder.append(path);
        }
        if (!this.mParams.isEmpty()) {
            urlBuilder.append("?");
            for (String key : this.mParams.keySet()) {
                urlBuilder.append(key).append("=").append(this.mParams.get(key)).append("&");
            }
            urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        }
        return urlBuilder.toString();
    }

    public String toString() {
        StringBuilder urlBuilder = new StringBuilder(this.mHost);
        for (String path : this.mPaths) {
            if (urlBuilder.charAt(urlBuilder.length() - 1) != '/') {
                urlBuilder.append("/");
            }
            urlBuilder.append(path);
        }
        if (!this.mParams.isEmpty()) {
            urlBuilder.append("?");
            for (String key : this.mParams.keySet()) {
                urlBuilder.append(key).append("=").append(this.mParams.get(key)).append("&");
            }
            urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        }
        return urlBuilder.toString();
    }
}

