/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events.hybrid;

import com.growingio.android.sdk.track.events.ViewElementEvent;
import org.json.JSONException;
import org.json.JSONObject;

public final class HybridViewElementEvent
extends ViewElementEvent {
    private static final long serialVersionUID = 1L;
    private final String mQuery;
    private final String mHyperlink;

    protected HybridViewElementEvent(Builder eventBuilder) {
        super(eventBuilder);
        this.mQuery = eventBuilder.mQuery;
        this.mHyperlink = eventBuilder.mHyperlink;
    }

    public String getQuery() {
        return this.checkValueSafe(this.mQuery);
    }

    public String getHyperlink() {
        return this.checkValueSafe(this.mHyperlink);
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        try {
            json.put("query", (Object)this.mQuery);
            json.put("hyperlink", (Object)this.mHyperlink);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static final class Builder
    extends ViewElementEvent.Builder {
        private String mQuery;
        private String mHyperlink;

        @Override
        public String getEventType() {
            return this.mEventType;
        }

        @Override
        public Builder setEventType(String eventType) {
            this.mEventType = eventType;
            return this;
        }

        @Override
        public HybridViewElementEvent build() {
            return new HybridViewElementEvent(this);
        }

        public Builder setQuery(String query) {
            this.mQuery = query;
            return this;
        }

        public Builder setHyperlink(String hyperlink) {
            this.mHyperlink = hyperlink;
            return this;
        }

        public Builder setDomain(String domain) {
            this.mDomain = domain;
            return this;
        }

        @Override
        public Builder setPath(String path) {
            super.setPath(path);
            return this;
        }

        @Override
        public Builder setPageShowTimestamp(long pageShowTimestamp) {
            super.setPageShowTimestamp(pageShowTimestamp);
            return this;
        }

        @Override
        public Builder setTextValue(String textValue) {
            super.setTextValue(textValue);
            return this;
        }

        @Override
        public Builder setXpath(String xpath) {
            super.setXpath(xpath);
            return this;
        }

        @Override
        public Builder setIndex(int index) {
            super.setIndex(index);
            return this;
        }
    }
}

