/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events.hybrid;

import com.growingio.android.sdk.track.events.PageEvent;
import org.json.JSONException;
import org.json.JSONObject;

public class HybridPageEvent
extends PageEvent {
    private static final long serialVersionUID = 1L;
    private final String mProtocolType;
    private final String mQuery;

    protected HybridPageEvent(Builder eventBuilder) {
        super(eventBuilder);
        this.mProtocolType = eventBuilder.mProtocolType;
        this.mQuery = eventBuilder.mQuery;
    }

    public String getQuery() {
        return this.checkValueSafe(this.mQuery);
    }

    public String getProtocolType() {
        return this.checkValueSafe(this.mProtocolType);
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        try {
            json.put("protocolType", (Object)this.mProtocolType);
            json.put("query", (Object)this.mQuery);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static class Builder
    extends PageEvent.Builder {
        private String mProtocolType;
        private String mQuery;

        public Builder setProtocolType(String protocolType) {
            this.mProtocolType = protocolType;
            return this;
        }

        public Builder setQuery(String query) {
            this.mQuery = query;
            return this;
        }

        public Builder setDomain(String domain) {
            this.mDomain = domain;
            return this;
        }

        @Override
        public HybridPageEvent build() {
            return new HybridPageEvent(this);
        }

        @Override
        public Builder setPath(String path) {
            super.setPath(path);
            return this;
        }

        @Override
        public Builder setTitle(String title) {
            super.setTitle(title);
            return this;
        }

        @Override
        public Builder setReferralPage(String referralPage) {
            super.setReferralPage(referralPage);
            return this;
        }

        @Override
        public Builder setTimestamp(long timestamp) {
            super.setTimestamp(timestamp);
            return this;
        }

        @Override
        public Builder setOrientation(String orientation) {
            super.setOrientation(orientation);
            return this;
        }
    }
}

