/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events.helper;

import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;

public class FieldIgnoreFilter {
    public static final int NONE = 0;
    public static final int NETWORK_STATE = 1;
    public static final int SCREEN_HEIGHT = 2;
    public static final int SCREEN_WIDTH = 4;
    public static final int DEVICE_BRAND = 8;
    public static final int DEVICE_MODEL = 16;
    public static final int DEVICE_TYPE = 32;
    public static final int FIELD_IGNORE_ALL = 63;
    private static final ArrayList<String> FIELD_NAME_LIST = new ArrayList<String>(Arrays.asList("networkState", "screenHeight", "screenWidth", "deviceBrand", "deviceModel", "deviceType"));

    private FieldIgnoreFilter() {
    }

    public static int of(int ... types) {
        int value = 0;
        if (types != null) {
            for (int type : types) {
                value |= type;
            }
        }
        return value;
    }

    public static int valueOf(String typeName) {
        return FIELD_NAME_LIST.contains(typeName) ? 1 << FIELD_NAME_LIST.indexOf(typeName) : 0;
    }

    public static boolean isFieldFilter(String typeName) {
        int ignoreFieldsFlag = ConfigurationProvider.core().getIgnoreField();
        if (ignoreFieldsFlag > 0) {
            int fieldMask = FieldIgnoreFilter.valueOf(typeName);
            return (ignoreFieldsFlag & fieldMask) > 0;
        }
        return false;
    }

    public static String getFieldFilterLog(int ignoreMask) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; ignoreMask > 0 && index < FIELD_NAME_LIST.size(); ignoreMask /= 2, ++index) {
            if (ignoreMask % 2 <= 0) continue;
            stringBuilder.append(FIELD_NAME_LIST.get(index));
            stringBuilder.append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.insert(0, "[").append("]");
            stringBuilder.append(" is ignoring ...");
            return stringBuilder.toString();
        }
        return "";
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface FieldFilterType {
    }
}

