/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events.helper;

import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;

public final class EventExcludeFilter {
    public static final int NONE = 0;
    public static final int VISIT = 1;
    public static final int CUSTOM = 2;
    public static final int VISITOR_ATTRIBUTES = 4;
    public static final int LOGIN_USER_ATTRIBUTES = 8;
    public static final int CONVERSION_VARIABLES = 16;
    public static final int APP_CLOSED = 32;
    public static final int PAGE = 64;
    public static final int PAGE_ATTRIBUTES = 128;
    public static final int VIEW_CLICK = 256;
    public static final int VIEW_CHANGE = 512;
    public static final int FORM_SUBMIT = 1024;
    public static final int REENGAGE = 2048;
    public static final int EVENT_MASK_TRIGGER = 1792;
    private static final ArrayList<String> EVENT_TYPE_LIST = new ArrayList<String>(Arrays.asList("VISIT", "CUSTOM", "VISITOR_ATTRIBUTES", "LOGIN_USER_ATTRIBUTES", "CONVERSION_VARIABLES", "APP_CLOSED", "PAGE", "PAGE_ATTRIBUTES", "VIEW_CLICK", "VIEW_CHANGE", "FORM_SUBMIT", "REENGAGE"));

    private EventExcludeFilter() {
    }

    public static int of(int ... types) {
        int value = 0;
        if (types != null) {
            for (int type : types) {
                value |= type;
            }
        }
        return value;
    }

    public static int valueOf(String typeName) {
        return EVENT_TYPE_LIST.contains(typeName) ? 1 << EVENT_TYPE_LIST.indexOf(typeName) : 0;
    }

    public static boolean isEventFilter(String typeName) {
        int filterFlag = ConfigurationProvider.core().getExcludeEvent();
        if (filterFlag > 0) {
            return (filterFlag & EventExcludeFilter.valueOf(typeName)) > 0;
        }
        return false;
    }

    public static String getEventFilterLog(int filterMask) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; filterMask > 0 && index < EVENT_TYPE_LIST.size(); filterMask /= 2, ++index) {
            if (filterMask % 2 <= 0) continue;
            stringBuilder.append(EVENT_TYPE_LIST.get(index));
            stringBuilder.append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.insert(0, "[").append("]");
            stringBuilder.append(" not tracking ...");
            return stringBuilder.toString();
        }
        return "";
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface EventFilterLimit {
    }
}

