/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events.base;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.text.TextUtils;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.events.helper.FieldIgnoreFilter;
import com.growingio.android.sdk.track.ipc.EventSequenceId;
import com.growingio.android.sdk.track.ipc.PersistentDataProvider;
import com.growingio.android.sdk.track.middleware.GEvent;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.providers.AppInfoProvider;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import com.growingio.android.sdk.track.providers.DeviceInfoProvider;
import com.growingio.android.sdk.track.providers.SessionProvider;
import com.growingio.android.sdk.track.providers.UserInfoProvider;
import com.growingio.android.sdk.track.utils.NetworkUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseEvent
extends GEvent {
    private static final long serialVersionUID = -6563998911329703050L;
    private static final String APP_STATE_FOREGROUND = "FOREGROUND";
    private static final String APP_STATE_BACKGROUND = "BACKGROUND";
    private final String mPlatform;
    private final String mPlatformVersion;
    private final String mDeviceId;
    private final String mUserKey;
    private final String mUserId;
    private final String mSessionId;
    private final String mEventType;
    private final long mTimestamp;
    private final String mDomain;
    private final String mUrlScheme;
    private final String mAppState;
    private final long mGlobalSequenceId;
    private final long mEventSequenceId;
    private final Map<String, String> mExtraParams;
    private final String mNetworkState;
    private final String mAppChannel;
    private final int mScreenHeight;
    private final int mScreenWidth;
    private final String mDeviceBrand;
    private final String mDeviceModel;
    private final String mDeviceType;
    private final String mAppName;
    private final String mAppVersion;
    private final String mLanguage;
    private final double mLatitude;
    private final double mLongitude;
    private final String mSdkVersion;

    protected BaseEvent(BaseBuilder<?> eventBuilder) {
        this.mPlatform = ((BaseBuilder)eventBuilder).mPlatform;
        this.mPlatformVersion = ((BaseBuilder)eventBuilder).mPlatformVersion;
        this.mDeviceId = ((BaseBuilder)eventBuilder).mDeviceId;
        this.mUserKey = ((BaseBuilder)eventBuilder).mUserKey;
        this.mUserId = ((BaseBuilder)eventBuilder).mUserId;
        this.mSessionId = eventBuilder.mSessionId;
        this.mEventType = eventBuilder.mEventType;
        this.mTimestamp = eventBuilder.mTimestamp;
        this.mDomain = eventBuilder.mDomain;
        this.mUrlScheme = ((BaseBuilder)eventBuilder).mUrlScheme;
        this.mAppState = ((BaseBuilder)eventBuilder).mAppState;
        this.mGlobalSequenceId = ((BaseBuilder)eventBuilder).mGlobalSequenceId;
        this.mEventSequenceId = ((BaseBuilder)eventBuilder).mEventSequenceId;
        this.mExtraParams = ((BaseBuilder)eventBuilder).mExtraParams;
        this.mNetworkState = ((BaseBuilder)eventBuilder).mNetworkState;
        this.mAppChannel = ((BaseBuilder)eventBuilder).mAppChannel;
        this.mScreenHeight = ((BaseBuilder)eventBuilder).mScreenHeight;
        this.mScreenWidth = ((BaseBuilder)eventBuilder).mScreenWidth;
        this.mDeviceBrand = ((BaseBuilder)eventBuilder).mDeviceBrand;
        this.mDeviceModel = ((BaseBuilder)eventBuilder).mDeviceModel;
        this.mDeviceType = ((BaseBuilder)eventBuilder).mDeviceType;
        this.mAppName = ((BaseBuilder)eventBuilder).mAppName;
        this.mAppVersion = ((BaseBuilder)eventBuilder).mAppVersion;
        this.mLanguage = ((BaseBuilder)eventBuilder).mLanguage;
        this.mLatitude = ((BaseBuilder)eventBuilder).mLatitude;
        this.mLongitude = ((BaseBuilder)eventBuilder).mLongitude;
        this.mSdkVersion = ((BaseBuilder)eventBuilder).mSdkVersion;
    }

    public String getDeviceId() {
        return this.checkValueSafe(this.mDeviceId);
    }

    public String getUserKey() {
        return this.checkValueSafe(this.mUserKey);
    }

    public String getUserId() {
        return this.checkValueSafe(this.mUserId);
    }

    public String getSessionId() {
        return this.checkValueSafe(this.mSessionId);
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public String getDomain() {
        return this.checkValueSafe(this.mDomain);
    }

    public String getUrlScheme() {
        return this.checkValueSafe(this.mUrlScheme);
    }

    public String getAppState() {
        return this.checkValueSafe(this.mAppState);
    }

    public long getGlobalSequenceId() {
        return this.mGlobalSequenceId;
    }

    public long getEventSequenceId() {
        return this.mEventSequenceId;
    }

    public String getNetworkState() {
        return this.checkValueSafe(this.mNetworkState);
    }

    public String getAppChannel() {
        return this.checkValueSafe(this.mAppChannel);
    }

    public int getScreenHeight() {
        return this.mScreenHeight;
    }

    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    public String getDeviceBrand() {
        return this.checkValueSafe(this.mDeviceBrand);
    }

    public String getDeviceModel() {
        return this.checkValueSafe(this.mDeviceModel);
    }

    public String getDeviceType() {
        return this.checkValueSafe(this.mDeviceType);
    }

    public String getAppName() {
        return this.checkValueSafe(this.mAppName);
    }

    public String getAppVersion() {
        return this.checkValueSafe(this.mAppVersion);
    }

    public String getLanguage() {
        return this.checkValueSafe(this.mLanguage);
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public String getSdkVersion() {
        return this.checkValueSafe(this.mSdkVersion);
    }

    public String getPlatform() {
        return this.checkValueSafe(this.mPlatform);
    }

    public String getPlatformVersion() {
        return this.checkValueSafe(this.mPlatformVersion);
    }

    public Map<String, String> getExtraParams() {
        return this.mExtraParams;
    }

    @Override
    public String getEventType() {
        return this.checkValueSafe(this.mEventType);
    }

    protected String checkValueSafe(String value) {
        return TextUtils.isEmpty((CharSequence)value) ? "" : value;
    }

    public JSONObject toJSONObject() {
        JSONObject json = !this.mExtraParams.isEmpty() ? new JSONObject(this.mExtraParams) : new JSONObject();
        try {
            json.put("platform", (Object)this.mPlatform);
            json.put("platformVersion", (Object)this.mPlatformVersion);
            json.put("deviceId", (Object)this.getDeviceId());
            if (!TextUtils.isEmpty((CharSequence)this.getUserKey())) {
                json.put("userKey", (Object)this.getUserKey());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getUserId())) {
                json.put("userId", (Object)this.getUserId());
            }
            json.put("sessionId", (Object)this.getSessionId());
            json.put("eventType", (Object)this.getEventType());
            json.put("timestamp", this.getTimestamp());
            json.put("domain", (Object)this.getDomain());
            json.put("urlScheme", (Object)this.getUrlScheme());
            json.put("appState", (Object)this.getAppState());
            json.put("globalSequenceId", this.getGlobalSequenceId());
            json.put("eventSequenceId", this.getEventSequenceId());
            if (!TextUtils.isEmpty((CharSequence)this.getNetworkState())) {
                json.put("networkState", (Object)this.getNetworkState());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getAppChannel())) {
                json.put("appChannel", (Object)this.getAppChannel());
            }
            if (this.getScreenHeight() > 0) {
                json.put("screenHeight", this.getScreenHeight());
            }
            if (this.getScreenWidth() > 0) {
                json.put("screenWidth", this.getScreenWidth());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getDeviceBrand())) {
                json.put("deviceBrand", (Object)this.getDeviceBrand());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getDeviceModel())) {
                json.put("deviceModel", (Object)this.getDeviceModel());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getDeviceType())) {
                json.put("deviceType", (Object)this.getDeviceType());
            }
            json.put("appName", (Object)this.getAppName());
            json.put("appVersion", (Object)this.getAppVersion());
            json.put("language", (Object)this.getLanguage());
            if (this.getLatitude() != 0.0 || this.getLongitude() != 0.0) {
                json.put("latitude", this.getLatitude());
                json.put("longitude", this.getLongitude());
            }
            json.put("sdkVersion", (Object)this.getSdkVersion());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static abstract class BaseBuilder<T extends BaseEvent> {
        private String mPlatform = "Android";
        private String mPlatformVersion;
        private String mDeviceId;
        private String mUserKey;
        private String mUserId;
        protected String mSessionId;
        protected String mEventType;
        protected long mTimestamp;
        protected String mDomain;
        private final String mUrlScheme;
        private final String mAppState;
        private long mGlobalSequenceId;
        private long mEventSequenceId;
        private final Map<String, String> mExtraParams = new HashMap<String, String>();
        private String mNetworkState;
        private String mAppChannel;
        private int mScreenHeight;
        private int mScreenWidth;
        private String mDeviceBrand;
        private String mDeviceModel;
        private String mDeviceType;
        private String mAppName;
        private String mAppVersion;
        private String mLanguage;
        private double mLatitude;
        private double mLongitude;
        private String mSdkVersion;

        protected BaseBuilder() {
            this.mPlatformVersion = DeviceInfoProvider.get().getOperatingSystemVersion();
            this.mEventType = this.getEventType();
            this.mAppState = ActivityStateProvider.get().getForegroundActivity() != null ? BaseEvent.APP_STATE_FOREGROUND : BaseEvent.APP_STATE_BACKGROUND;
            this.mDomain = AppInfoProvider.get().getPackageName();
            this.mUrlScheme = ConfigurationProvider.core().getUrlScheme();
        }

        @CallSuper
        public void readPropertyInTrackThread() {
            this.mTimestamp = this.mTimestamp != 0L ? this.mTimestamp : System.currentTimeMillis();
            this.mDeviceId = DeviceInfoProvider.get().getDeviceId();
            this.mSessionId = PersistentDataProvider.get().getSessionId();
            this.mUserKey = UserInfoProvider.get().getLoginUserKey();
            this.mUserId = UserInfoProvider.get().getLoginUserId();
            EventSequenceId sequenceId = PersistentDataProvider.get().getAndIncrement(this.mEventType);
            this.mGlobalSequenceId = sequenceId.getGlobalId();
            this.mEventSequenceId = sequenceId.getEventTypeId();
            Context context = TrackerContext.get().getApplicationContext();
            this.mNetworkState = FieldIgnoreFilter.isFieldFilter("networkState") ? "" : NetworkUtil.getActiveNetworkState(context).getNetworkName();
            DeviceInfoProvider deviceInfo = DeviceInfoProvider.get();
            this.mScreenHeight = FieldIgnoreFilter.isFieldFilter("screenHeight") ? 0 : deviceInfo.getScreenHeight();
            this.mScreenWidth = FieldIgnoreFilter.isFieldFilter("screenWidth") ? 0 : deviceInfo.getScreenWidth();
            this.mDeviceBrand = FieldIgnoreFilter.isFieldFilter("deviceBrand") ? "" : deviceInfo.getDeviceBrand();
            this.mDeviceModel = FieldIgnoreFilter.isFieldFilter("deviceModel") ? "" : deviceInfo.getDeviceModel();
            this.mDeviceType = FieldIgnoreFilter.isFieldFilter("deviceType") ? "" : deviceInfo.getDeviceType();
            AppInfoProvider appInfo = AppInfoProvider.get();
            this.mAppChannel = appInfo.getAppChannel();
            this.mAppName = appInfo.getAppName();
            this.mAppVersion = appInfo.getAppVersion();
            SessionProvider session = SessionProvider.get();
            this.mLatitude = session.getLatitude();
            this.mLongitude = session.getLongitude();
            this.mSdkVersion = "3.3.6";
            this.mLanguage = Locale.getDefault().getLanguage();
        }

        public BaseBuilder<?> addExtraParam(String key, String value) {
            this.mExtraParams.put(key, value);
            return this;
        }

        public abstract String getEventType();

        public abstract T build();
    }
}

