/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events;

import android.text.TextUtils;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.providers.DeviceInfoProvider;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class VisitEvent
extends BaseEvent {
    private static final long serialVersionUID = 1L;
    private final String mImei;
    private final String mAndroidId;
    private final String mOaid;
    private final String mGoogleAdvertisingId;
    private final Map<String, String> mExtraSdk;

    protected VisitEvent(Builder eventBuilder) {
        super(eventBuilder);
        this.mImei = eventBuilder.mImei;
        this.mAndroidId = eventBuilder.mAndroidId;
        this.mOaid = eventBuilder.mOaid;
        this.mGoogleAdvertisingId = eventBuilder.mGoogleAdvertisingId;
        this.mExtraSdk = eventBuilder.mExtraSdk;
    }

    @Override
    public int getSendPolicy() {
        return 1;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.getImei())) {
                json.put("imei", (Object)this.getImei());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getAndroidId())) {
                json.put("androidId", (Object)this.getAndroidId());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getOaid())) {
                json.put("oaid", (Object)this.getOaid());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getGoogleAdvertisingId())) {
                json.put("googleAdvertisingId", (Object)this.getGoogleAdvertisingId());
            }
            if (this.getExtraSdk() != null && !this.getExtraSdk().isEmpty()) {
                json.put("extraSdk", this.getExtraSdk());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public String getImei() {
        return this.checkValueSafe(this.mImei);
    }

    public String getAndroidId() {
        return this.checkValueSafe(this.mAndroidId);
    }

    public String getOaid() {
        return this.checkValueSafe(this.mOaid);
    }

    public String getGoogleAdvertisingId() {
        return this.checkValueSafe(this.mGoogleAdvertisingId);
    }

    public Map<String, String> getExtraSdk() {
        return this.mExtraSdk;
    }

    public static final class Builder
    extends BaseEvent.BaseBuilder<VisitEvent> {
        private String mImei;
        private String mAndroidId;
        private String mOaid;
        private String mGoogleAdvertisingId;
        private Map<String, String> mExtraSdk;

        Builder() {
        }

        @Override
        public String getEventType() {
            return "VISIT";
        }

        @Override
        public void readPropertyInTrackThread() {
            super.readPropertyInTrackThread();
            DeviceInfoProvider deviceInfo = DeviceInfoProvider.get();
            this.mImei = deviceInfo.getImei();
            this.mAndroidId = deviceInfo.getAndroidId();
            this.mOaid = deviceInfo.getOaid();
            this.mGoogleAdvertisingId = "";
        }

        public Builder setExtraSdk(Map<String, String> extraSdk) {
            this.mExtraSdk = extraSdk;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.mSessionId = sessionId;
            return this;
        }

        @Override
        public VisitEvent build() {
            return new VisitEvent(this);
        }
    }
}

