/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events;

import android.text.TextUtils;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import org.json.JSONException;
import org.json.JSONObject;

public class ViewElementEvent
extends BaseEvent {
    private static final long serialVersionUID = 1L;
    private final String mPath;
    private final long mPageShowTimestamp;
    private final String mTextValue;
    private final String mXpath;
    private final int mIndex;

    protected ViewElementEvent(Builder eventBuilder) {
        super(eventBuilder);
        this.mPath = eventBuilder.mPath;
        this.mPageShowTimestamp = eventBuilder.mPageShowTimestamp;
        this.mTextValue = eventBuilder.mTextValue;
        this.mXpath = eventBuilder.mXpath;
        this.mIndex = eventBuilder.mIndex;
    }

    public String getPath() {
        return this.checkValueSafe(this.mPath);
    }

    public long getPageShowTimestamp() {
        return this.mPageShowTimestamp;
    }

    public String getTextValue() {
        return this.checkValueSafe(this.mTextValue);
    }

    public String getXpath() {
        return this.checkValueSafe(this.mXpath);
    }

    public int getIndex() {
        return this.mIndex;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        try {
            json.put("path", (Object)this.getPath());
            json.put("pageShowTimestamp", this.getPageShowTimestamp());
            if (!TextUtils.isEmpty((CharSequence)this.getTextValue())) {
                json.put("textValue", (Object)this.getTextValue());
            }
            json.put("xpath", (Object)this.getXpath());
            json.put("index", this.getIndex());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static class Builder
    extends BaseEvent.BaseBuilder<ViewElementEvent> {
        private String mPath;
        private long mPageShowTimestamp;
        private String mTextValue;
        private String mXpath;
        private int mIndex = -1;

        @Override
        public String getEventType() {
            return this.mEventType;
        }

        public Builder setEventType(String eventType) {
            this.mEventType = eventType;
            return this;
        }

        public Builder setPath(String path) {
            this.mPath = path;
            return this;
        }

        public Builder setPageShowTimestamp(long pageShowTimestamp) {
            this.mPageShowTimestamp = pageShowTimestamp;
            return this;
        }

        public Builder setTextValue(String textValue) {
            this.mTextValue = textValue;
            return this;
        }

        public Builder setXpath(String xpath) {
            this.mXpath = xpath;
            return this;
        }

        public Builder setIndex(int index) {
            this.mIndex = index;
            return this;
        }

        @Override
        public ViewElementEvent build() {
            return new ViewElementEvent(this);
        }
    }
}

