/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events;

import com.growingio.android.sdk.track.events.base.BaseEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONException;
import org.json.JSONObject;

public class PageEvent
extends BaseEvent {
    private static final long serialVersionUID = 1L;
    public static final String ORIENTATION_PORTRAIT = "PORTRAIT";
    public static final String ORIENTATION_LANDSCAPE = "LANDSCAPE";
    private final String mPath;
    private final String mOrientation;
    private final String mTitle;
    private final String mReferralPage;

    protected PageEvent(Builder eventBuilder) {
        super(eventBuilder);
        this.mPath = eventBuilder.mPath;
        this.mOrientation = eventBuilder.mOrientation;
        this.mTitle = eventBuilder.mTitle;
        this.mReferralPage = eventBuilder.mReferralPage;
    }

    public String getPath() {
        return this.checkValueSafe(this.mPath);
    }

    public String getOrientation() {
        return this.checkValueSafe(this.mOrientation);
    }

    public String getTitle() {
        return this.checkValueSafe(this.mTitle);
    }

    public String getReferralPage() {
        return this.checkValueSafe(this.mReferralPage);
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        try {
            json.put("path", (Object)this.getPath());
            json.put("orientation", (Object)this.getOrientation());
            json.put("title", (Object)this.getTitle());
            json.put("referralPage", (Object)this.getReferralPage());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static class Builder
    extends BaseEvent.BaseBuilder<PageEvent> {
        private String mPath;
        private String mOrientation = "PORTRAIT";
        private String mTitle;
        private String mReferralPage = "";

        public Builder setPath(String path) {
            this.mPath = path;
            return this;
        }

        public Builder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public Builder setReferralPage(String referralPage) {
            this.mReferralPage = referralPage;
            return this;
        }

        public Builder setOrientation(String orientation) {
            this.mOrientation = orientation;
            return this;
        }

        @Override
        public String getEventType() {
            return "PAGE";
        }

        @Override
        public PageEvent build() {
            return new PageEvent(this);
        }

        @Override
        public void readPropertyInTrackThread() {
            super.readPropertyInTrackThread();
        }

        public Builder setTimestamp(long timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

