/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events;

import com.growingio.android.sdk.track.events.base.BaseAttributesEvent;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PageAttributesEvent
extends BaseAttributesEvent {
    private static final long serialVersionUID = 1L;
    private final String mPath;
    private final long mPageShowTimestamp;

    protected PageAttributesEvent(Builder eventBuilder) {
        super(eventBuilder);
        this.mPath = eventBuilder.mPath;
        this.mPageShowTimestamp = eventBuilder.mPageShowTimestamp;
    }

    public String getPath() {
        return this.checkValueSafe(this.mPath);
    }

    public long getPageShowTimestamp() {
        return this.mPageShowTimestamp;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        try {
            json.put("path", (Object)this.getPath());
            json.put("pageShowTimestamp", this.getPageShowTimestamp());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static class Builder
    extends BaseAttributesEvent.Builder<PageAttributesEvent> {
        private String mPath;
        private long mPageShowTimestamp;

        public Builder setPath(String path) {
            this.mPath = path;
            return this;
        }

        public Builder setPageShowTimestamp(long pageShowTimestamp) {
            this.mPageShowTimestamp = pageShowTimestamp;
            return this;
        }

        public Builder setAttributes(Map<String, String> attributes) {
            super.setAttributes(attributes);
            return this;
        }

        @Override
        public String getEventType() {
            return "PAGE_ATTRIBUTES";
        }

        @Override
        public PageAttributesEvent build() {
            return new PageAttributesEvent(this);
        }
    }
}

