/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.events;

import com.growingio.android.sdk.track.events.base.BaseAttributesEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomEvent
extends BaseAttributesEvent {
    private static final long serialVersionUID = 1L;
    private final String mEventName;

    protected CustomEvent(Builder eventBuilder) {
        super(eventBuilder);
        this.mEventName = eventBuilder.mEventName;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        try {
            json.put("eventName", (Object)this.getEventName());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public String getEventName() {
        return this.checkValueSafe(this.mEventName);
    }

    public static class AttributesBuilder {
        Map<String, String> attributes = new HashMap<String, String>();
        private static final String LIST_SPLIT = "||";

        private AttributesBuilder() {
        }

        public static AttributesBuilder getAttributesBuilder() {
            return new AttributesBuilder();
        }

        public AttributesBuilder addAttribute(String key, String value) {
            if (key != null && value != null) {
                this.attributes.put(key, value);
            }
            return this;
        }

        public <T> AttributesBuilder addAttribute(String key, List<T> value) {
            if (key != null && value != null && !value.isEmpty()) {
                StringBuilder valueBuilder = new StringBuilder();
                Iterator<T> iterator = value.iterator();
                if (iterator.hasNext()) {
                    valueBuilder.append(this.toString(iterator.next()));
                    while (iterator.hasNext()) {
                        valueBuilder.append(LIST_SPLIT);
                        valueBuilder.append(this.toString(iterator.next()));
                    }
                }
                this.attributes.put(key, valueBuilder.toString());
            }
            return this;
        }

        public Map<String, String> getAttributes() {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return null;
            }
            return this.attributes;
        }

        private String toString(Object value) {
            if (value == null) {
                return "";
            }
            return String.valueOf(value);
        }
    }

    public static class Builder
    extends BaseAttributesEvent.Builder<CustomEvent> {
        private String mEventName;

        @Override
        public String getEventType() {
            return "CUSTOM";
        }

        public Builder setEventName(String eventName) {
            this.mEventName = eventName;
            return this;
        }

        public Builder setAttributes(Map<String, String> attributes) {
            super.setAttributes(attributes);
            return this;
        }

        @Override
        public CustomEvent build() {
            return new CustomEvent(this);
        }
    }
}

