/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.async;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.growingio.android.sdk.track.async.Disposable;
import com.growingio.android.sdk.track.async.EmptyDisposable;

public class HandlerDisposable
implements Disposable {
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private volatile boolean mDisposed;

    public Disposable schedule(Runnable run, long timeout) {
        if (this.mDisposed) {
            return EmptyDisposable.INSTANCE;
        }
        ScheduledRunnable scheduled = new ScheduledRunnable(this.mHandler, run);
        Message message = Message.obtain((Handler)this.mHandler, (Runnable)scheduled);
        message.obj = this;
        this.mHandler.sendMessageDelayed(message, timeout);
        return scheduled;
    }

    @Override
    public void dispose() {
        this.mDisposed = true;
        this.mHandler.removeCallbacksAndMessages((Object)this);
    }

    @Override
    public boolean isDisposed() {
        return this.mDisposed;
    }

    private static final class ScheduledRunnable
    implements Runnable,
    Disposable {
        private final Handler mScheduledHandler;
        private final Runnable mDelegate;
        private volatile boolean mScheduledDisposed;

        ScheduledRunnable(Handler handler, Runnable delegate) {
            this.mScheduledHandler = handler;
            this.mDelegate = delegate;
        }

        @Override
        public void run() {
            this.mScheduledDisposed = true;
            this.mDelegate.run();
        }

        @Override
        public void dispose() {
            this.mScheduledHandler.removeCallbacks((Runnable)this);
            this.mScheduledDisposed = true;
        }

        @Override
        public boolean isDisposed() {
            return this.mScheduledDisposed;
        }
    }
}

