/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import com.growingio.android.sdk.CoreConfiguration;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.events.EventBuildInterceptor;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.events.helper.EventExcludeFilter;
import com.growingio.android.sdk.track.interfaces.OnTrackMainInitSDKCallback;
import com.growingio.android.sdk.track.ipc.PersistentDataProvider;
import com.growingio.android.sdk.track.listener.ListenerContainer;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.EventHttpSender;
import com.growingio.android.sdk.track.middleware.EventSender;
import com.growingio.android.sdk.track.middleware.GEvent;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import com.growingio.android.sdk.track.providers.SessionProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class TrackMainThread
extends ListenerContainer<OnTrackMainInitSDKCallback, Void> {
    private static final String TAG = "TrackMainThread";
    private static final int MSG_INIT_SDK = 1;
    private final Looper mMainLooper;
    private final Handler mMainHandler;
    private final EventSender mEventSender;
    private final List<EventBuildInterceptor> mEventBuildInterceptors = new ArrayList<EventBuildInterceptor>();

    private TrackMainThread() {
        CoreConfiguration configuration = ConfigurationProvider.core();
        int uploadInterval = configuration.isDebugEnabled() ? 0 : configuration.getDataUploadInterval();
        this.mEventSender = new EventSender(TrackerContext.get().getApplicationContext(), new EventHttpSender(), uploadInterval, configuration.getCellularDataLimit());
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mMainLooper = handlerThread.getLooper();
        this.mMainHandler = new H(this.mMainLooper);
        this.mMainHandler.sendEmptyMessage(1);
    }

    public EventSender getEventSender() {
        return this.mEventSender;
    }

    @Override
    protected void singleAction(OnTrackMainInitSDKCallback listener, Void action) {
        listener.onTrackMainInitSDK();
    }

    public static TrackMainThread trackMain() {
        return SingleInstance.INSTANCE;
    }

    public Looper getMainLooper() {
        return this.mMainLooper;
    }

    void initSDK() {
        this.mEventSender.removeOverdueEvents();
        this.dispatchActions(null);
    }

    public void postEventToTrackMain(final BaseEvent.BaseBuilder<?> eventBuilder) {
        this.postActionToTrackMain(new Runnable(){

            @Override
            public void run() {
                if (eventBuilder == null) {
                    return;
                }
                if (ConfigurationProvider.core().isDataCollectionEnabled()) {
                    if (EventExcludeFilter.isEventFilter(eventBuilder.getEventType())) {
                        return;
                    }
                    if (!PersistentDataProvider.get().isSendVisitAfterRefreshSessionId()) {
                        SessionProvider.get().generateVisit();
                    }
                    TrackMainThread.this.onGenerateGEvent(eventBuilder);
                }
            }
        });
    }

    public void postGEventToTrackMain(final GEvent gEvent) {
        this.postActionToTrackMain(new Runnable(){

            @Override
            public void run() {
                if (gEvent == null) {
                    return;
                }
                if (ConfigurationProvider.core().isDataCollectionEnabled()) {
                    TrackMainThread.this.cacheEvent(gEvent);
                }
            }
        });
    }

    public void postActionToTrackMain(Runnable runnable) {
        if (this.mMainHandler.getLooper() == Looper.myLooper()) {
            runnable.run();
            return;
        }
        this.mMainHandler.post(runnable);
    }

    void onGenerateGEvent(BaseEvent.BaseBuilder<?> gEvent) {
        gEvent.readPropertyInTrackThread();
        this.dispatchEventWillBuild(gEvent);
        Object event = gEvent.build();
        this.dispatchEventDidBuild((GEvent)event);
        this.saveEvent((GEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventBuildInterceptor(EventBuildInterceptor interceptor) {
        List<EventBuildInterceptor> list = this.mEventBuildInterceptors;
        synchronized (list) {
            if (interceptor != null) {
                this.mEventBuildInterceptors.remove(interceptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventBuildInterceptor(EventBuildInterceptor interceptor) {
        List<EventBuildInterceptor> list = this.mEventBuildInterceptors;
        synchronized (list) {
            boolean needsAdd = true;
            Iterator<EventBuildInterceptor> refIter = this.mEventBuildInterceptors.iterator();
            while (refIter.hasNext()) {
                EventBuildInterceptor storedInterceptor = refIter.next();
                if (null == storedInterceptor) {
                    refIter.remove();
                    continue;
                }
                if (storedInterceptor != interceptor) continue;
                needsAdd = false;
            }
            if (needsAdd) {
                this.mEventBuildInterceptors.add(interceptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEventWillBuild(BaseEvent.BaseBuilder<?> eventBuilder) {
        List<EventBuildInterceptor> list = this.mEventBuildInterceptors;
        synchronized (list) {
            Iterator<EventBuildInterceptor> refIter = this.mEventBuildInterceptors.iterator();
            while (refIter.hasNext()) {
                EventBuildInterceptor interceptor = refIter.next();
                if (null == interceptor) {
                    refIter.remove();
                    continue;
                }
                try {
                    interceptor.eventWillBuild(eventBuilder);
                }
                catch (Exception e) {
                    Logger.e(TAG, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEventDidBuild(GEvent event) {
        List<EventBuildInterceptor> list = this.mEventBuildInterceptors;
        synchronized (list) {
            Iterator<EventBuildInterceptor> refIter = this.mEventBuildInterceptors.iterator();
            while (refIter.hasNext()) {
                EventBuildInterceptor interceptor = refIter.next();
                if (null == interceptor) {
                    refIter.remove();
                    continue;
                }
                try {
                    interceptor.eventDidBuild(event);
                }
                catch (Exception e) {
                    Logger.e(TAG, e);
                }
            }
        }
    }

    private void saveEvent(GEvent event) {
        if (event instanceof BaseEvent) {
            Logger.printJson(TAG, "save: event, type is " + event.getEventType(), ((BaseEvent)event).toJSONObject().toString());
        }
        this.mEventSender.sendEvent(event);
    }

    private void cacheEvent(GEvent event) {
        if (event instanceof BaseEvent) {
            Logger.printJson(TAG, "cache: event, type is " + event.getEventType(), ((BaseEvent)event).toJSONObject().toString());
        } else {
            Logger.d(TAG, "cache: event, type is " + event.getEventType() + event.toString(), new Object[0]);
        }
        this.mEventSender.cacheEvent(event);
    }

    private class H
    extends Handler {
        private H(Looper looper) {
            super(looper);
        }

        public void handleMessage(@NonNull Message msg) {
            if (msg.what == 1) {
                TrackMainThread.this.initSDK();
                return;
            }
            throw new IllegalStateException("Unexpected value: " + msg.what);
        }
    }

    private static class SingleInstance {
        private static final TrackMainThread INSTANCE = new TrackMainThread();

        private SingleInstance() {
        }
    }
}

