/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk;

import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.modelloader.DataFetcher;
import com.growingio.android.sdk.track.modelloader.LoadDataFetcher;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.modelloader.TrackerRegistry;

public class TrackerContext
extends ContextWrapper {
    private static final String TAG = "ContextProvider";
    private static volatile TrackerContext INSTANCE = null;
    private static volatile boolean sInitializedSuccessfully = false;
    private final TrackerRegistry registry = new TrackerRegistry();

    public static boolean initializedSuccessfully() {
        if (INSTANCE == null) {
            return false;
        }
        return sInitializedSuccessfully;
    }

    public static void initSuccess() {
        sInitializedSuccessfully = true;
    }

    private TrackerContext(Application application) {
        super((Context)application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Application application) {
        Class<TrackerContext> clazz = TrackerContext.class;
        synchronized (TrackerContext.class) {
            if (null == INSTANCE) {
                INSTANCE = new TrackerContext(application);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static TrackerContext get() {
        if (null == INSTANCE) {
            Logger.e(TAG, new NullPointerException("you should init growingio sdk first"));
        }
        return INSTANCE;
    }

    public TrackerRegistry getRegistry() {
        return this.registry;
    }

    public <Model, Data> Data executeData(Model model, Class<Model> modelClass, Class<Data> dataClass) {
        ModelLoader<Model, Data> modelLoader = this.getRegistry().getModelLoader(modelClass, dataClass);
        if (modelLoader != null) {
            return modelLoader.buildLoadData(model).fetcher.executeData();
        }
        return null;
    }

    public <Model, Data> void loadData(Model model, Class<Model> modelClass, Class<Data> dataClass, LoadDataFetcher.DataCallback<Data> callback) {
        ModelLoader<Model, Data> modelLoader = this.getRegistry().getModelLoader(modelClass, dataClass);
        if (modelLoader != null) {
            DataFetcher fetcher = modelLoader.buildLoadData(model).fetcher;
            if (fetcher instanceof LoadDataFetcher) {
                ((LoadDataFetcher)fetcher).loadData(callback);
            }
        } else {
            callback.onLoadFailed(new NullPointerException(String.format("please register %s component first", modelClass.getSimpleName())));
        }
    }
}

