/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.growingio.android.sdk.GeneratedGioModule;
import com.growingio.android.sdk.LibraryGioModule;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.TrackMainThread;
import com.growingio.android.sdk.track.events.CustomEvent;
import com.growingio.android.sdk.track.events.LoginUserAttributesEvent;
import com.growingio.android.sdk.track.events.TrackEventGenerator;
import com.growingio.android.sdk.track.ipc.PersistentDataProvider;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.modelloader.data.HybridBridge;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import com.growingio.android.sdk.track.providers.DeepLinkProvider;
import com.growingio.android.sdk.track.providers.DeviceInfoProvider;
import com.growingio.android.sdk.track.providers.SessionProvider;
import com.growingio.android.sdk.track.providers.UserInfoProvider;
import com.growingio.android.sdk.track.utils.ClassExistHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class Tracker {
    private static final String TAG = "GrowingIO Track SDK";
    protected volatile boolean isInited = false;

    public Tracker(Application application) {
        if (application == null) {
            this.isInited = false;
            Logger.e(TAG, "GrowingIO Track SDK is UNINITIALIZED, please initialized before use API", new Object[0]);
            return;
        }
        this.setup(application);
        this.start();
        TrackerContext.initSuccess();
        this.isInited = true;
    }

    @CallSuper
    protected void setup(Application application) {
        TrackerContext.init(application);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ActivityStateProvider.get());
        DeepLinkProvider.get().init();
        SessionProvider.get().init();
        this.loadAnnotationGeneratedModules((Context)application);
        for (LibraryGioModule component : ConfigurationProvider.core().getPreloadComponents()) {
            component.registerComponents((Context)application, TrackerContext.get().getRegistry());
        }
    }

    private void start() {
        PersistentDataProvider.get().start();
    }

    public void trackCustomEvent(String eventName) {
        if (!this.isInited) {
            return;
        }
        this.trackCustomEvent(eventName, null);
    }

    public void trackCustomEvent(String eventName, Map<String, String> attributes) {
        if (!this.isInited) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            Logger.e(TAG, "trackCustomEvent: eventName is NULL", new Object[0]);
            return;
        }
        if (attributes != null) {
            attributes = new HashMap<String, String>(attributes);
        }
        TrackEventGenerator.generateCustomEvent(eventName, attributes);
    }

    public void trackCustomEventWithAttrBuilder(String eventName, CustomEvent.AttributesBuilder attributesBuilder) {
        if (!this.isInited) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            Logger.e(TAG, "trackCustomEventWithAttrBuilder: eventName is NULL", new Object[0]);
            return;
        }
        TrackEventGenerator.generateCustomEvent(eventName, attributesBuilder.getAttributes());
    }

    public void setConversionVariables(Map<String, String> variables) {
        if (!this.isInited) {
            return;
        }
        if (variables == null || variables.isEmpty()) {
            Logger.e(TAG, "setConversionVariables: variables is NULL", new Object[0]);
            return;
        }
        TrackEventGenerator.generateConversionVariablesEvent(new HashMap<String, String>(variables));
    }

    public void setLoginUserAttributes(Map<String, String> attributes) {
        if (!this.isInited) {
            return;
        }
        if (attributes == null || attributes.isEmpty()) {
            Logger.e(TAG, "setLoginUserAttributes: attributes is NULL", new Object[0]);
            return;
        }
        TrackEventGenerator.generateLoginUserAttributesEvent(new HashMap<String, String>(attributes));
    }

    public void setLoginUserAttributesWithAttrBuilder(LoginUserAttributesEvent.AttributesBuilder attributesBuilder) {
        if (!this.isInited) {
            return;
        }
        Map<String, String> attributes = attributesBuilder.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            Logger.e(TAG, "setLoginUserAttributesWithAttrBuilder: attributes is NULL", new Object[0]);
            return;
        }
        TrackEventGenerator.generateLoginUserAttributesEvent(attributes);
    }

    public void setVisitorAttributes(Map<String, String> attributes) {
        if (!this.isInited) {
            return;
        }
        if (attributes == null || attributes.isEmpty()) {
            Logger.e(TAG, "setVisitorAttributes: attributes is NULL", new Object[0]);
            return;
        }
        TrackEventGenerator.generateVisitorAttributesEvent(new HashMap<String, String>(attributes));
    }

    @Nullable
    public String getDeviceId() {
        if (!this.isInited) {
            return "UNKNOWN";
        }
        return DeviceInfoProvider.get().getDeviceId();
    }

    public void setDataCollectionEnabled(final boolean enabled) {
        if (!this.isInited) {
            return;
        }
        TrackMainThread.trackMain().postActionToTrackMain(new Runnable(){

            @Override
            public void run() {
                if (enabled == ConfigurationProvider.core().isDataCollectionEnabled()) {
                    Logger.e(Tracker.TAG, "\u5f53\u524d\u6570\u636e\u91c7\u96c6\u5f00\u5173 = " + enabled + ", \u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", new Object[0]);
                } else {
                    ConfigurationProvider.core().setDataCollectionEnabled(enabled);
                    if (enabled) {
                        SessionProvider.get().generateVisit();
                    }
                }
            }
        });
    }

    public void setLoginUserId(String userId) {
        if (!this.isInited) {
            return;
        }
        TrackMainThread.trackMain().postActionToTrackMain(() -> UserInfoProvider.get().setLoginUserId(userId));
    }

    public void setLoginUserId(String userId, String userKey) {
        if (!this.isInited) {
            return;
        }
        TrackMainThread.trackMain().postActionToTrackMain(() -> UserInfoProvider.get().setLoginUserId(userId, userKey));
    }

    public void cleanLoginUserId() {
        if (!this.isInited) {
            return;
        }
        TrackMainThread.trackMain().postActionToTrackMain(() -> UserInfoProvider.get().setLoginUserId(null));
    }

    public void setLocation(double latitude, double longitude) {
        if (!this.isInited) {
            return;
        }
        TrackMainThread.trackMain().postActionToTrackMain(() -> SessionProvider.get().setLocation(latitude, longitude));
    }

    public void cleanLocation() {
        if (!this.isInited) {
            return;
        }
        TrackMainThread.trackMain().postActionToTrackMain(() -> SessionProvider.get().cleanLocation());
    }

    public void onActivityNewIntent(@NonNull Activity activity, Intent intent) {
        if (!this.isInited) {
            return;
        }
        ActivityStateProvider.get().onActivityNewIntent(activity, intent);
    }

    public void bridgeWebView(View webView) {
        if (!this.isInited) {
            return;
        }
        if (ClassExistHelper.isWebView(webView)) {
            this.bridgeInnerWebView(webView);
        } else {
            Logger.e(TAG, "please check your " + webView.getClass().getName() + "is WebView or com.tencent.smtt.sdk.WebView or com.uc.webview.export.WebView", new Object[0]);
        }
    }

    private void bridgeInnerWebView(View view) {
        boolean result = false;
        ModelLoader<HybridBridge, Boolean> modelLoader = TrackerContext.get().getRegistry().getModelLoader(HybridBridge.class, Boolean.class);
        if (modelLoader != null) {
            result = (Boolean)modelLoader.buildLoadData((HybridBridge)new HybridBridge((View)view)).fetcher.executeData();
        }
        Logger.d(TAG, "bridgeForWebView: webView = " + view.getClass().getName() + ", result = " + result, new Object[0]);
    }

    private void loadAnnotationGeneratedModules(Context context) {
        try {
            Class<?> clazz = Class.forName("com.growingio.android.sdk.GeneratedGioModuleImpl");
            GeneratedGioModule generatedGioModule = (GeneratedGioModule)clazz.getDeclaredConstructor(Context.class).newInstance(context.getApplicationContext());
            generatedGioModule.registerComponents(context, TrackerContext.get().getRegistry());
        }
        catch (ClassNotFoundException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Failed to find GeneratedGioModule. You should include an annotationProcessor compile dependency on com.growingio.android.sdk:compiler in your application and a @GIOModule annotated AppGioModule implementation or LibraryGioModules will be silently ignored");
            }
        }
        catch (InstantiationException e) {
            this.throwIncorrectGioModule(e);
        }
        catch (IllegalAccessException e) {
            this.throwIncorrectGioModule(e);
        }
        catch (NoSuchMethodException e) {
            this.throwIncorrectGioModule(e);
        }
        catch (InvocationTargetException e) {
            this.throwIncorrectGioModule(e);
        }
    }

    public void registerComponent(LibraryGioModule module) {
        if (!this.isInited || module == null) {
            return;
        }
        module.registerComponents((Context)TrackerContext.get(), TrackerContext.get().getRegistry());
    }

    private void throwIncorrectGioModule(Exception e) {
        throw new IllegalStateException("GeneratedGioModuleImpl is implemented incorrectly. If you've manually implemented this class, remove your implementation. The Annotation processor will generate a correct implementation.", e);
    }
}

