/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk;

import android.text.TextUtils;
import com.growingio.android.sdk.Configurable;
import com.growingio.android.sdk.LibraryGioModule;
import com.growingio.android.sdk.track.events.helper.EventExcludeFilter;
import com.growingio.android.sdk.track.events.helper.FieldIgnoreFilter;
import com.growingio.android.sdk.track.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.List;

public class CoreConfiguration
implements Configurable {
    private String mProjectId;
    private String mUrlScheme;
    private String mChannel;
    private boolean mDebugEnabled = false;
    private int mCellularDataLimit = 10;
    private int mDataUploadInterval = 15;
    private int mSessionInterval = 30;
    private boolean mDataCollectionEnabled = true;
    private boolean mUploadExceptionEnabled = true;
    private boolean mRequireAppProcessesEnabled = true;
    private String mDataCollectionServerHost = "http://api.growingio.com";
    @ObjectUtils.FieldToString(clazz=EventExcludeFilter.class, method="getEventFilterLog", parameterTypes={int.class})
    private int mExcludeEventFlag = 0;
    @ObjectUtils.FieldToString(clazz=FieldIgnoreFilter.class, method="getFieldFilterLog", parameterTypes={int.class})
    private int mIgnoreFieldFlag = 0;
    private final List<LibraryGioModule> mComponents = new ArrayList<LibraryGioModule>();
    private boolean mIdMappingEnabled = false;

    public CoreConfiguration(String projectId, String urlScheme) {
        this.mProjectId = projectId;
        this.mUrlScheme = urlScheme;
    }

    public CoreConfiguration setProject(String projectId, String urlScheme) {
        this.mProjectId = projectId;
        this.mUrlScheme = urlScheme;
        return this;
    }

    public String getProjectId() {
        return this.mProjectId;
    }

    public boolean isDataCollectionEnabled() {
        return this.mDataCollectionEnabled;
    }

    public CoreConfiguration setDataCollectionEnabled(boolean dataCollectionEnabled) {
        this.mDataCollectionEnabled = dataCollectionEnabled;
        return this;
    }

    public String getUrlScheme() {
        return this.mUrlScheme;
    }

    public String getChannel() {
        return this.mChannel;
    }

    public CoreConfiguration setChannel(String channel) {
        this.mChannel = channel;
        return this;
    }

    public boolean isUploadExceptionEnabled() {
        return this.mUploadExceptionEnabled;
    }

    public CoreConfiguration setUploadExceptionEnabled(boolean uploadExceptionEnabled) {
        this.mUploadExceptionEnabled = uploadExceptionEnabled;
        return this;
    }

    public boolean isDebugEnabled() {
        return this.mDebugEnabled;
    }

    public CoreConfiguration setDebugEnabled(boolean enabled) {
        this.mDebugEnabled = enabled;
        return this;
    }

    public int getCellularDataLimit() {
        return this.mCellularDataLimit;
    }

    public CoreConfiguration setCellularDataLimit(int cellularDataLimit) {
        this.mCellularDataLimit = cellularDataLimit;
        return this;
    }

    public int getDataUploadInterval() {
        return this.mDataUploadInterval;
    }

    public CoreConfiguration setDataUploadInterval(int dataUploadInterval) {
        this.mDataUploadInterval = dataUploadInterval;
        return this;
    }

    public int getSessionInterval() {
        return this.mSessionInterval;
    }

    public CoreConfiguration setSessionInterval(int sessionInterval) {
        this.mSessionInterval = sessionInterval;
        return this;
    }

    public String getDataCollectionServerHost() {
        return this.mDataCollectionServerHost;
    }

    public CoreConfiguration setDataCollectionServerHost(String dataCollectionServerHost) {
        if (!TextUtils.isEmpty((CharSequence)dataCollectionServerHost)) {
            this.mDataCollectionServerHost = dataCollectionServerHost;
        }
        return this;
    }

    public CoreConfiguration setExcludeEvent(@EventExcludeFilter.EventFilterLimit int filterEventFlag) {
        this.mExcludeEventFlag = filterEventFlag == 0 ? 0 : (this.mExcludeEventFlag |= filterEventFlag);
        return this;
    }

    public int getExcludeEvent() {
        return this.mExcludeEventFlag;
    }

    public CoreConfiguration setIgnoreField(@FieldIgnoreFilter.FieldFilterType int ignoreFieldFlag) {
        this.mIgnoreFieldFlag = ignoreFieldFlag == 0 ? 0 : (this.mIgnoreFieldFlag |= ignoreFieldFlag);
        return this;
    }

    public int getIgnoreField() {
        return this.mIgnoreFieldFlag;
    }

    @Deprecated
    public CoreConfiguration setPreloadComponent(LibraryGioModule component) {
        return this.addPreloadComponent(component);
    }

    public CoreConfiguration addPreloadComponent(LibraryGioModule component) {
        if (component == null) {
            return this;
        }
        this.mComponents.add(component);
        return this;
    }

    protected List<LibraryGioModule> getPreloadComponents() {
        return this.mComponents;
    }

    public boolean isIdMappingEnabled() {
        return this.mIdMappingEnabled;
    }

    public CoreConfiguration setIdMappingEnabled(boolean enabled) {
        this.mIdMappingEnabled = enabled;
        return this;
    }

    public boolean isRequireAppProcessesEnabled() {
        return this.mRequireAppProcessesEnabled;
    }

    public CoreConfiguration setRequireAppProcessesEnabled(boolean enabled) {
        this.mRequireAppProcessesEnabled = enabled;
        return this;
    }
}

