/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.hybrid;

import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import com.growingio.android.hybrid.HybridBridgeProvider;
import com.growingio.android.hybrid.NativeBridge;
import com.growingio.android.hybrid.WebViewJavascriptBridgeConfiguration;
import com.growingio.android.sdk.track.log.Logger;

class WebViewBridgeJavascriptInterface {
    static final String JAVASCRIPT_INTERFACE_NAME = "GrowingWebViewJavascriptBridge";
    static final String JAVASCRIPT_GET_DOM_TREE_METHOD = "window.GrowingWebViewJavascriptBridge.getDomTree";
    private static final String TAG = "WebViewBridge";
    private final WebViewJavascriptBridgeConfiguration mConfiguration;
    private final NativeBridge mNativeBridge = new NativeBridge();

    WebViewBridgeJavascriptInterface(WebViewJavascriptBridgeConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    @JavascriptInterface
    @com.uc.webview.export.JavascriptInterface
    public String getConfiguration() {
        return this.mConfiguration.toJSONObject().toString();
    }

    @JavascriptInterface
    @com.uc.webview.export.JavascriptInterface
    public void onDomChanged() {
        HybridBridgeProvider.get().onDomChanged();
    }

    @JavascriptInterface
    @com.uc.webview.export.JavascriptInterface
    public void dispatchEvent(String event) {
        Logger.printJson((String)TAG, (String)"dispatchEvent: ", (String)event);
        if (TextUtils.isEmpty((CharSequence)event)) {
            return;
        }
        this.mNativeBridge.dispatchEvent(event);
    }

    @JavascriptInterface
    @com.uc.webview.export.JavascriptInterface
    public void setNativeUserId(String userId) {
        Logger.d((String)TAG, (String)("setNativeUserId: " + userId), (Object[])new Object[0]);
        this.mNativeBridge.setNativeUserId(userId);
    }

    @JavascriptInterface
    @com.uc.webview.export.JavascriptInterface
    public void clearNativeUserId() {
        Logger.d((String)TAG, (String)"clearNativeUserId: ", (Object[])new Object[0]);
        this.mNativeBridge.clearNativeUserId();
    }

    @JavascriptInterface
    @com.uc.webview.export.JavascriptInterface
    public void setNativeUserIdAndUserKey(String userId, String userKey) {
        Logger.d((String)TAG, (String)("setNativeUserIdAndUserKey: " + userId + ", " + userKey), (Object[])new Object[0]);
        this.mNativeBridge.setNativeUserIdAndUserKey(userId, userKey);
    }

    @JavascriptInterface
    @com.uc.webview.export.JavascriptInterface
    public void clearNativeUserIdAndUserKey() {
        Logger.d((String)TAG, (String)"clearNativeUserIdAndUserKey: ", (Object[])new Object[0]);
        this.mNativeBridge.clearNativeUserIdAndUserKey();
    }
}

