/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.hybrid;

import android.annotation.SuppressLint;
import android.os.Build;
import android.view.View;
import android.webkit.ValueCallback;
import com.growingio.android.hybrid.R;
import com.tencent.smtt.sdk.WebView;

public abstract class SuperWebView<T extends View> {
    private final T mRealWebView;
    private boolean hasAddJavaScript = false;

    protected SuperWebView(T realWebView) {
        this.mRealWebView = realWebView;
    }

    public T getRealWebView() {
        return this.mRealWebView;
    }

    public void getLocationOnScreen(int[] outLocation) {
        this.getRealWebView().getLocationOnScreen(outLocation);
    }

    public int getHeight() {
        return this.getRealWebView().getHeight();
    }

    public int getWidth() {
        return this.getRealWebView().getWidth();
    }

    public abstract void setJavaScriptEnabled(boolean var1);

    public abstract void addJavascriptInterface(Object var1, String var2);

    public abstract void evaluateJavascript(String var1, ValueCallback<String> var2);

    public boolean hasAddJavaScripted() {
        return this.mRealWebView.getTag(R.id.growing_tracker_has_add_java_script) != null;
    }

    public void setAddJavaScript() {
        this.mRealWebView.setTag(R.id.growing_tracker_has_add_java_script, new Object());
    }

    public static SuperWebView<android.webkit.WebView> make(android.webkit.WebView webView) {
        return new SystemWebView(webView);
    }

    public static SuperWebView<WebView> makeX5(WebView webView) {
        return new X5WebView(webView);
    }

    public static SuperWebView<com.uc.webview.export.WebView> makeUC(com.uc.webview.export.WebView webView) {
        return new UCWebView(webView);
    }

    private static final class UCWebView
    extends SuperWebView<com.uc.webview.export.WebView> {
        protected UCWebView(com.uc.webview.export.WebView realWebView) {
            super(realWebView);
        }

        @Override
        public void setJavaScriptEnabled(boolean flag) {
            ((com.uc.webview.export.WebView)this.getRealWebView()).getSettings().setJavaScriptEnabled(flag);
        }

        @Override
        public void addJavascriptInterface(Object obj, String interfaceName) {
            ((com.uc.webview.export.WebView)this.getRealWebView()).addJavascriptInterface(obj, interfaceName);
        }

        @Override
        public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
            ((com.uc.webview.export.WebView)this.getRealWebView()).evaluateJavascript(script, resultCallback);
        }
    }

    private static final class X5WebView
    extends SuperWebView<WebView> {
        protected X5WebView(WebView realWebView) {
            super(realWebView);
        }

        @Override
        public void setJavaScriptEnabled(boolean flag) {
            ((WebView)this.getRealWebView()).getSettings().setJavaScriptEnabled(flag);
        }

        @Override
        public void addJavascriptInterface(Object obj, String interfaceName) {
            ((WebView)this.getRealWebView()).addJavascriptInterface(obj, interfaceName);
        }

        @Override
        public void evaluateJavascript(String script, final ValueCallback<String> resultCallback) {
            ((WebView)this.getRealWebView()).evaluateJavascript(script, (com.tencent.smtt.sdk.ValueCallback)new com.tencent.smtt.sdk.ValueCallback<String>(){

                public void onReceiveValue(String s) {
                    if (resultCallback != null) {
                        resultCallback.onReceiveValue((Object)s);
                    }
                }
            });
        }
    }

    private static final class SystemWebView
    extends SuperWebView<android.webkit.WebView> {
        protected SystemWebView(android.webkit.WebView realWebView) {
            super(realWebView);
        }

        @Override
        public void setJavaScriptEnabled(boolean flag) {
            ((android.webkit.WebView)this.getRealWebView()).getSettings().setJavaScriptEnabled(flag);
        }

        @Override
        @SuppressLint(value={"JavascriptInterface"})
        public void addJavascriptInterface(Object obj, String interfaceName) {
            ((android.webkit.WebView)this.getRealWebView()).addJavascriptInterface(obj, interfaceName);
        }

        @Override
        public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
            if (Build.VERSION.SDK_INT >= 19) {
                ((android.webkit.WebView)this.getRealWebView()).evaluateJavascript(script, resultCallback);
            }
        }
    }
}

