/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.hybrid;

import com.growingio.android.hybrid.HybridTransformer;
import com.growingio.android.hybrid.HybridTransformerImp;
import com.growingio.android.sdk.track.TrackMainThread;
import com.growingio.android.sdk.track.providers.UserInfoProvider;

class NativeBridge {
    private static final String TAG = "NativeBridge";
    private final HybridTransformer mHybridTransformer = new HybridTransformerImp();

    NativeBridge() {
    }

    void dispatchEvent(String event) {
        TrackMainThread.trackMain().postEventToTrackMain(this.mHybridTransformer.transform(event));
    }

    void setNativeUserId(final String userId) {
        TrackMainThread.trackMain().postActionToTrackMain(new Runnable(){

            @Override
            public void run() {
                UserInfoProvider.get().setLoginUserId(userId);
            }
        });
    }

    void clearNativeUserId() {
        TrackMainThread.trackMain().postActionToTrackMain(new Runnable(){

            @Override
            public void run() {
                UserInfoProvider.get().setLoginUserId(null);
            }
        });
    }

    void setNativeUserIdAndUserKey(final String userId, final String userKey) {
        TrackMainThread.trackMain().postActionToTrackMain(new Runnable(){

            @Override
            public void run() {
                UserInfoProvider.get().setLoginUserId(userId, userKey);
            }
        });
    }

    void clearNativeUserIdAndUserKey() {
        TrackMainThread.trackMain().postActionToTrackMain(new Runnable(){

            @Override
            public void run() {
                UserInfoProvider.get().setLoginUserId(null, null);
            }
        });
    }
}

