/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.hybrid;

import android.app.Activity;
import android.text.TextUtils;
import com.growingio.android.hybrid.HybridTransformer;
import com.growingio.android.sdk.track.events.ConversionVariablesEvent;
import com.growingio.android.sdk.track.events.LoginUserAttributesEvent;
import com.growingio.android.sdk.track.events.VisitorAttributesEvent;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.events.hybrid.HybridCustomEvent;
import com.growingio.android.sdk.track.events.hybrid.HybridPageAttributesEvent;
import com.growingio.android.sdk.track.events.hybrid.HybridPageEvent;
import com.growingio.android.sdk.track.events.hybrid.HybridViewElementEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.providers.AppInfoProvider;
import com.growingio.android.sdk.track.utils.JsonUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class HybridTransformerImp
implements HybridTransformer {
    private static final String TAG = "HybridTransformerImp";
    private static final String KEY_EVENT_TYPE = "eventType";
    private static final String KEY_DOMAIN = "domain";
    private static final String KEY_PATH = "path";
    private static final String KEY_PROTOCOL_TYPE = "protocolType";
    private static final String KEY_QUERY = "query";
    private static final String KEY_REFERRAL_PAGE = "referralPage";
    private static final String KEY_TITLE = "title";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_PAGE_SHOW_TIMESTAMP = "pageShowTimestamp";
    private static final String KEY_ATTRIBUTES = "attributes";
    private static final String KEY_EVENT_NAME = "eventName";
    private static final String KEY_HYPERLINK = "hyperlink";
    private static final String KEY_INDEX = "index";
    private static final String KEY_TEXT_VALUE = "textValue";
    private static final String KEY_XPATH = "xpath";

    @Override
    public BaseEvent.BaseBuilder<?> transform(String hybridEvent) {
        try {
            JSONObject eventJson = new JSONObject(hybridEvent);
            String type = eventJson.getString(KEY_EVENT_TYPE);
            if ("PAGE".equals(type)) {
                String orientation = "PORTRAIT";
                Activity activity = ActivityStateProvider.get().getForegroundActivity();
                if (activity != null) {
                    orientation = activity.getResources().getConfiguration().orientation == 1 ? "PORTRAIT" : "LANDSCAPE";
                }
                return new HybridPageEvent.Builder().setDomain(this.getDomain(eventJson)).setProtocolType(eventJson.getString(KEY_PROTOCOL_TYPE)).setQuery(eventJson.optString(KEY_QUERY)).setPath(eventJson.getString(KEY_PATH)).setReferralPage(eventJson.optString(KEY_REFERRAL_PAGE)).setTitle(eventJson.optString(KEY_TITLE)).setTimestamp(eventJson.getLong(KEY_TIMESTAMP)).setOrientation(orientation);
            }
            if ("PAGE_ATTRIBUTES".equals(type)) {
                return new HybridPageAttributesEvent.Builder().setDomain(this.getDomain(eventJson)).setQuery(eventJson.optString(KEY_QUERY)).setPath(eventJson.getString(KEY_PATH)).setPageShowTimestamp(eventJson.getLong(KEY_PAGE_SHOW_TIMESTAMP)).setAttributes(JsonUtil.copyToMap((JSONObject)eventJson.getJSONObject(KEY_ATTRIBUTES)));
            }
            if ("VIEW_CLICK".equals(type)) {
                return this.transformViewElementEventBuilder(eventJson).setEventType(type);
            }
            if ("VIEW_CHANGE".equals(type)) {
                return this.transformViewElementEventBuilder(eventJson).setEventType(type);
            }
            if ("FORM_SUBMIT".equals(type)) {
                return this.transformViewElementEventBuilder(eventJson).setEventType(type);
            }
            if ("CUSTOM".equals(type)) {
                return new HybridCustomEvent.Builder().setDomain(this.getDomain(eventJson)).setQuery(eventJson.optString(KEY_QUERY)).setPath(eventJson.getString(KEY_PATH)).setPageShowTimestamp(eventJson.getLong(KEY_PAGE_SHOW_TIMESTAMP)).setEventName(eventJson.getString(KEY_EVENT_NAME)).setAttributes(JsonUtil.copyToMap((JSONObject)eventJson.optJSONObject(KEY_ATTRIBUTES)));
            }
            if ("LOGIN_USER_ATTRIBUTES".equals(type)) {
                return new LoginUserAttributesEvent.Builder().setAttributes(JsonUtil.copyToMap((JSONObject)eventJson.getJSONObject(KEY_ATTRIBUTES)));
            }
            if ("VISITOR_ATTRIBUTES".equals(type)) {
                return new VisitorAttributesEvent.Builder().setAttributes(JsonUtil.copyToMap((JSONObject)eventJson.getJSONObject(KEY_ATTRIBUTES)));
            }
            if ("CONVERSION_VARIABLES".equals(type)) {
                return new ConversionVariablesEvent.Builder().setAttributes(JsonUtil.copyToMap((JSONObject)eventJson.getJSONObject(KEY_ATTRIBUTES)));
            }
        }
        catch (JSONException e) {
            Logger.e((String)TAG, (String)e.getMessage(), (Object[])new Object[]{e});
        }
        return null;
    }

    private String getDomain(JSONObject event) {
        String domain = event.optString(KEY_DOMAIN);
        if (TextUtils.isEmpty((CharSequence)domain)) {
            domain = AppInfoProvider.get().getPackageName();
        }
        return domain;
    }

    private HybridViewElementEvent.Builder transformViewElementEventBuilder(JSONObject eventJson) throws JSONException {
        return new HybridViewElementEvent.Builder().setHyperlink(eventJson.optString(KEY_HYPERLINK)).setDomain(this.getDomain(eventJson)).setQuery(eventJson.optString(KEY_QUERY)).setIndex(eventJson.optInt(KEY_INDEX, -1)).setTextValue(eventJson.optString(KEY_TEXT_VALUE)).setXpath(eventJson.getString(KEY_XPATH)).setPath(eventJson.getString(KEY_PATH)).setPageShowTimestamp(eventJson.getLong(KEY_PAGE_SHOW_TIMESTAMP));
    }
}

