/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.hybrid;

import android.view.View;
import com.growingio.android.hybrid.HybridBridgeProvider;
import com.growingio.android.hybrid.SuperWebView;
import com.growingio.android.sdk.track.async.Callback;
import com.growingio.android.sdk.track.modelloader.DataFetcher;
import com.growingio.android.sdk.track.modelloader.LoadDataFetcher;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.modelloader.ModelLoaderFactory;
import com.growingio.android.sdk.track.modelloader.data.HybridDom;
import com.growingio.android.sdk.track.modelloader.data.HybridJson;
import com.growingio.android.sdk.track.utils.ClassExistHelper;
import com.tencent.smtt.sdk.WebView;
import org.json.JSONObject;

public class HybridDomLoader
implements ModelLoader<HybridDom, HybridJson> {
    private HybridDom.OnDomChangedListener onDomChangedListener;

    public ModelLoader.LoadData<HybridJson> buildLoadData(HybridDom eventData) {
        if (eventData.getOnDomChangedListener() != null) {
            this.onDomChangedListener = eventData.getOnDomChangedListener();
            HybridBridgeProvider.get().registerDomChangedListener(() -> this.onDomChangedListener.onDomChanged());
        }
        return new ModelLoader.LoadData((DataFetcher)new HybridDataFetcher(eventData));
    }

    public static class HybridDataFetcher
    implements LoadDataFetcher<HybridJson> {
        private static final String TAG = "HybridDataFetcher";
        private final HybridDom dom;

        public HybridDataFetcher(HybridDom eventData) {
            this.dom = eventData;
        }

        public void loadData(final LoadDataFetcher.DataCallback<? super HybridJson> callback) {
            if (this.dom.getView() == null) {
                callback.onLoadFailed((Exception)new NullPointerException("webview is null"));
                return;
            }
            SuperWebView<? extends View> superWebView = this.getSuperWebView();
            if (superWebView == null) {
                callback.onLoadFailed((Exception)new IllegalArgumentException(this.dom.getView().getClass().getName() + "is not webView"));
                return;
            }
            HybridBridgeProvider.get().getWebViewDomTree(superWebView, new Callback<JSONObject>(){

                public void onSuccess(JSONObject result) {
                    callback.onDataReady((Object)new HybridJson(result));
                }

                public void onFailed() {
                    callback.onLoadFailed((Exception)new RuntimeException("getWebViewDomTree error"));
                }
            });
        }

        public SuperWebView<? extends View> getSuperWebView() {
            if (this.dom.getView() instanceof android.webkit.WebView) {
                return SuperWebView.make((android.webkit.WebView)this.dom.getView());
            }
            if (ClassExistHelper.instanceOfX5WebView((Object)this.dom.getView())) {
                return SuperWebView.makeX5((WebView)this.dom.getView());
            }
            if (ClassExistHelper.instanceOfUcWebView((Object)this.dom.getView())) {
                return SuperWebView.makeUC((com.uc.webview.export.WebView)this.dom.getView());
            }
            return null;
        }

        public HybridJson executeData() {
            return new HybridJson(new JSONObject());
        }

        public Class<HybridJson> getDataClass() {
            return HybridJson.class;
        }
    }

    public static class Factory
    implements ModelLoaderFactory<HybridDom, HybridJson> {
        public ModelLoader<HybridDom, HybridJson> build() {
            return new HybridDomLoader();
        }
    }
}

