/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.hybrid;

import android.annotation.SuppressLint;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.ValueCallback;
import com.growingio.android.hybrid.OnDomChangedListener;
import com.growingio.android.hybrid.SuperWebView;
import com.growingio.android.hybrid.WebViewBridgeJavascriptInterface;
import com.growingio.android.hybrid.WebViewJavascriptBridgeConfiguration;
import com.growingio.android.sdk.track.async.Callback;
import com.growingio.android.sdk.track.async.Disposable;
import com.growingio.android.sdk.track.async.HandlerDisposable;
import com.growingio.android.sdk.track.listener.ListenerContainer;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.AppInfoProvider;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import org.json.JSONException;
import org.json.JSONObject;

public class HybridBridgeProvider
extends ListenerContainer<OnDomChangedListener, Void> {
    private static final String TAG = "HybridBridgePolicy";
    private static final int EVALUATE_JAVASCRIPT_TIMEOUT = 5000;

    private HybridBridgeProvider() {
    }

    public static HybridBridgeProvider get() {
        return SingleInstance.INSTANCE;
    }

    private WebViewJavascriptBridgeConfiguration getJavascriptBridgeConfiguration() {
        String projectId = ConfigurationProvider.core().getProjectId();
        String appId = ConfigurationProvider.core().getUrlScheme();
        String appPackage = AppInfoProvider.get().getPackageName();
        String nativeSdkVersion = "3.3.6";
        int nativeSdkVersionCode = 30306;
        return new WebViewJavascriptBridgeConfiguration(projectId, appId, appPackage, nativeSdkVersion, nativeSdkVersionCode);
    }

    public void onDomChanged() {
        this.dispatchActions(null);
    }

    public void registerDomChangedListener(OnDomChangedListener listener) {
        this.register(listener);
    }

    public void unregisterDomChangedListener(OnDomChangedListener listener) {
        this.unregister(listener);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void bridgeForWebView(SuperWebView<?> webView) {
        webView.setJavaScriptEnabled(true);
        if (webView.hasAddJavaScripted()) {
            Logger.d((String)TAG, (String)"JavascriptInterface has already been added to the WebView", (Object[])new Object[0]);
            return;
        }
        webView.addJavascriptInterface(new WebViewBridgeJavascriptInterface(this.getJavascriptBridgeConfiguration()), "GrowingWebViewJavascriptBridge");
        webView.setAddJavaScript();
    }

    public Disposable getWebViewDomTree(SuperWebView<?> webView, final Callback<JSONObject> callback) {
        Logger.d((String)TAG, (String)"getWebViewDomTree", (Object[])new Object[0]);
        if (callback == null) {
            return Disposable.EMPTY_DISPOSABLE;
        }
        final Disposable disposable = new HandlerDisposable().schedule(() -> {
            Logger.e((String)TAG, (String)"getWebViewDomTree timeout", (Object[])new Object[0]);
            callback.onFailed();
        }, 5000L);
        if (Build.VERSION.SDK_INT >= 19) {
            int[] location = new int[2];
            webView.getLocationOnScreen(location);
            webView.evaluateJavascript("javascript:window.GrowingWebViewJavascriptBridge.getDomTree(" + location[0] + ", " + location[1] + ", " + webView.getWidth() + ", " + webView.getHeight() + ", 100)", new ValueCallback<String>(){

                public void onReceiveValue(String value) {
                    if (disposable.isDisposed()) {
                        return;
                    }
                    disposable.dispose();
                    if (TextUtils.isEmpty((CharSequence)value) || "null".equals(value)) {
                        Logger.e((String)HybridBridgeProvider.TAG, (String)"getWebViewDomTree ValueCallback is NULL", (Object[])new Object[0]);
                        callback.onFailed();
                        return;
                    }
                    try {
                        JSONObject domTree = new JSONObject(value);
                        callback.onSuccess((Object)domTree);
                    }
                    catch (JSONException e) {
                        Logger.e((String)HybridBridgeProvider.TAG, (Throwable)e);
                        callback.onFailed();
                    }
                }
            });
        } else {
            Logger.e((String)TAG, (String)"You need use after Android 4.4 to getWebViewDomTree", (Object[])new Object[0]);
            if (!disposable.isDisposed()) {
                disposable.dispose();
            }
            callback.onFailed();
        }
        return disposable;
    }

    protected void singleAction(OnDomChangedListener listener, Void action) {
        listener.onDomChanged();
    }

    private static class SingleInstance {
        private static final HybridBridgeProvider INSTANCE = new HybridBridgeProvider();

        private SingleInstance() {
        }
    }
}

