/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.marshaller.json;

import com.growingio.android.sdk.monitor.event.interfaces.ExceptionInterface;
import com.growingio.android.sdk.monitor.event.interfaces.MonitorException;
import com.growingio.android.sdk.monitor.event.interfaces.StackTraceInterface;
import com.growingio.android.sdk.monitor.marshaller.json.InterfaceBinding;
import java.util.Deque;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExceptionInterfaceBinding
implements InterfaceBinding<ExceptionInterface> {
    private static final String TYPE_PARAMETER = "type";
    private static final String VALUE_PARAMETER = "value";
    private static final String MODULE_PARAMETER = "module";
    private final InterfaceBinding<StackTraceInterface> stackTraceInterfaceBinding;

    public ExceptionInterfaceBinding(InterfaceBinding<StackTraceInterface> stackTraceInterfaceBinding) {
        this.stackTraceInterfaceBinding = stackTraceInterfaceBinding;
    }

    @Override
    public void writeInterface(JSONObject generator, ExceptionInterface monitorInterface) throws JSONException {
        Deque<MonitorException> exceptions = monitorInterface.getExceptions();
        JSONArray exceptionsJson = new JSONArray();
        Iterator<MonitorException> iterator = exceptions.descendingIterator();
        while (iterator.hasNext()) {
            exceptionsJson.put((Object)this.getExceptionJsonObject(iterator.next()));
        }
        generator.put(monitorInterface.getInterfaceName(), (Object)exceptionsJson);
    }

    private JSONObject getExceptionJsonObject(MonitorException monitorException) throws JSONException {
        JSONObject exceptionJson = new JSONObject();
        exceptionJson.put(TYPE_PARAMETER, (Object)monitorException.getExceptionClassName());
        exceptionJson.put(VALUE_PARAMETER, (Object)monitorException.getExceptionMessage());
        exceptionJson.put(MODULE_PARAMETER, (Object)monitorException.getExceptionPackageName());
        this.stackTraceInterfaceBinding.writeInterface(exceptionJson, monitorException.getStackTraceInterface());
        return exceptionJson;
    }
}

