/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.event.interfaces;

import com.growingio.android.sdk.monitor.event.interfaces.StackTraceInterface;
import com.growingio.android.sdk.monitor.jvmti.FrameCache;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;

public final class MonitorException
implements Serializable {
    public static final String DEFAULT_PACKAGE_NAME = "(default)";
    private final String exceptionMessage;
    private final String exceptionClassName;
    private final String exceptionPackageName;
    private final StackTraceInterface stackTraceInterface;

    public MonitorException(Throwable throwable, StackTraceElement[] childExceptionStackTrace) {
        this.exceptionMessage = throwable.getMessage();
        this.exceptionClassName = throwable.getClass().getSimpleName();
        Package exceptionPackage = throwable.getClass().getPackage();
        this.exceptionPackageName = exceptionPackage != null ? exceptionPackage.getName() : null;
        this.stackTraceInterface = new StackTraceInterface(throwable.getStackTrace(), childExceptionStackTrace, FrameCache.get(throwable));
    }

    public MonitorException(String exceptionMessage, String exceptionClassName, String exceptionPackageName, StackTraceInterface stackTraceInterface) {
        this.exceptionMessage = exceptionMessage;
        this.exceptionClassName = exceptionClassName;
        this.exceptionPackageName = exceptionPackageName;
        this.stackTraceInterface = stackTraceInterface;
    }

    public static Deque<MonitorException> extractExceptionQueue(Throwable throwable) {
        ArrayDeque<MonitorException> exceptions = new ArrayDeque<MonitorException>();
        HashSet<Throwable> circularityDetector = new HashSet<Throwable>();
        StackTraceElement[] childExceptionStackTrace = new StackTraceElement[]{};
        while (throwable != null && circularityDetector.add(throwable)) {
            exceptions.add(new MonitorException(throwable, childExceptionStackTrace));
            childExceptionStackTrace = throwable.getStackTrace();
            throwable = throwable.getCause();
        }
        return exceptions;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public String getExceptionPackageName() {
        return this.exceptionPackageName != null ? this.exceptionPackageName : DEFAULT_PACKAGE_NAME;
    }

    public StackTraceInterface getStackTraceInterface() {
        return this.stackTraceInterface;
    }

    public String toString() {
        return "MonitorException{exceptionMessage='" + this.exceptionMessage + '\'' + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionPackageName='" + this.exceptionPackageName + '\'' + ", stackTraceInterface=" + this.stackTraceInterface + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorException that = (MonitorException)o;
        if (!this.exceptionClassName.equals(that.exceptionClassName)) {
            return false;
        }
        if (this.exceptionMessage != null ? !this.exceptionMessage.equals(that.exceptionMessage) : that.exceptionMessage != null) {
            return false;
        }
        if (this.exceptionPackageName != null ? !this.exceptionPackageName.equals(that.exceptionPackageName) : that.exceptionPackageName != null) {
            return false;
        }
        return this.stackTraceInterface.equals(that.stackTraceInterface);
    }

    public int hashCode() {
        int result = this.exceptionMessage != null ? this.exceptionMessage.hashCode() : 0;
        result = 31 * result + this.exceptionClassName.hashCode();
        result = 31 * result + (this.exceptionPackageName != null ? this.exceptionPackageName.hashCode() : 0);
        return result;
    }
}

