/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.event.interfaces;

import com.growingio.android.sdk.monitor.event.interfaces.MonitorInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MessageInterface
implements MonitorInterface {
    public static final String MESSAGE_INTERFACE = "sentry.interfaces.Message";
    private final String message;
    private final List<String> parameters;
    private final String formatted;

    public MessageInterface(String message) {
        this(message, Collections.emptyList());
    }

    public MessageInterface(String message, String ... params) {
        this(message, Arrays.asList(params));
    }

    public MessageInterface(String message, List<String> parameters) {
        this(message, parameters, null);
    }

    public MessageInterface(String message, List<String> parameters, String formatted) {
        this.message = message;
        this.parameters = Collections.unmodifiableList(new ArrayList<String>(parameters));
        this.formatted = formatted;
    }

    @Override
    public String getInterfaceName() {
        return MESSAGE_INTERFACE;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public String toString() {
        return "MessageInterface{message='" + this.message + '\'' + ", parameters=" + this.parameters + ", formatted=" + this.formatted + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageInterface that = (MessageInterface)o;
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return this.formatted != null ? this.formatted.equals(that.formatted) : that.formatted == null;
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.formatted != null ? this.formatted.hashCode() : 0);
        return result;
    }
}

