/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.event.helper;

import com.growingio.android.sdk.monitor.MonitorClient;
import com.growingio.android.sdk.monitor.context.Context;
import com.growingio.android.sdk.monitor.event.Breadcrumb;
import com.growingio.android.sdk.monitor.event.EventBuilder;
import com.growingio.android.sdk.monitor.event.User;
import com.growingio.android.sdk.monitor.event.helper.EventBuilderHelper;
import com.growingio.android.sdk.monitor.event.interfaces.UserInterface;
import java.util.List;
import java.util.Map;

public class ContextBuilderHelper
implements EventBuilderHelper {
    private MonitorClient mMonitorClient;

    public ContextBuilderHelper(MonitorClient monitorClient) {
        this.mMonitorClient = monitorClient;
    }

    @Override
    public void helpBuildingEvent(EventBuilder eventBuilder) {
        Map<String, Object> extra;
        Map<String, String> tags;
        Context context = this.mMonitorClient.getContext();
        List<Breadcrumb> breadcrumbs = context.getBreadcrumbs();
        if (!breadcrumbs.isEmpty()) {
            eventBuilder.withBreadcrumbs(breadcrumbs);
        }
        if (context.getUser() != null) {
            eventBuilder.withMonitorInterface(this.fromUser(context.getUser()));
        }
        if (!(tags = context.getTags()).isEmpty()) {
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                eventBuilder.withTag(entry.getKey(), entry.getValue());
            }
        }
        if (!(extra = context.getExtra()).isEmpty()) {
            for (Map.Entry<String, Object> entry : extra.entrySet()) {
                eventBuilder.withExtra(entry.getKey(), entry.getValue());
            }
        }
    }

    private UserInterface fromUser(User user) {
        return new UserInterface(user.getId(), user.getUsername(), user.getData());
    }
}

