/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.event;

import com.growingio.android.sdk.monitor.event.Breadcrumb;
import com.growingio.android.sdk.monitor.event.Event;
import com.growingio.android.sdk.monitor.event.MonitorSdk;
import com.growingio.android.sdk.monitor.event.interfaces.MonitorInterface;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class EventBuilder {
    public static final String DEFAULT_PLATFORM = "java";
    private final Event event;
    private boolean alreadyBuilt = false;
    private Set<String> sdkIntegrations = new HashSet<String>();

    public EventBuilder() {
        this(UUID.randomUUID());
    }

    public EventBuilder(UUID eventId) {
        this.event = new Event(eventId);
    }

    private void autoSetMissingValues() {
        if (this.event.getTimestamp() == null) {
            this.event.setTimestamp(new Date());
        }
        if (this.event.getPlatform() == null) {
            this.event.setPlatform(DEFAULT_PLATFORM);
        }
        if (this.event.getSdk() == null) {
            this.event.setSdk(new MonitorSdk("sentry-java", "1.7.16-9b60b", this.sdkIntegrations));
        }
    }

    private void makeImmutable() {
        this.event.setTags(Collections.unmodifiableMap(this.event.getTags()));
        this.event.setBreadcrumbs(Collections.unmodifiableList(this.event.getBreadcrumbs()));
        HashMap<String, Map<String, Object>> tempContexts = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> contextEntry : this.event.getContexts().entrySet()) {
            tempContexts.put(contextEntry.getKey(), Collections.unmodifiableMap(contextEntry.getValue()));
        }
        this.event.setContexts(Collections.unmodifiableMap(tempContexts));
        this.event.setExtra(Collections.unmodifiableMap(this.event.getExtra()));
        this.event.setMonitorInterfaces(Collections.unmodifiableMap(this.event.getMonitorInterfaces()));
    }

    public EventBuilder withAlias(String alias) {
        this.event.setAlias(alias);
        return this;
    }

    public EventBuilder withMessage(String message) {
        this.event.setMessage(message);
        return this;
    }

    public EventBuilder withTimestamp(Date timestamp) {
        this.event.setTimestamp(timestamp);
        return this;
    }

    public EventBuilder withLevel(Event.Level level) {
        this.event.setLevel(level);
        return this;
    }

    public EventBuilder withRelease(String release) {
        this.event.setRelease(release);
        return this;
    }

    public EventBuilder withDist(String dist) {
        this.event.setDist(dist);
        return this;
    }

    public EventBuilder withEnvironment(String environment) {
        this.event.setEnvironment(environment);
        return this;
    }

    public EventBuilder withPlatform(String platform) {
        this.event.setPlatform(platform);
        return this;
    }

    public EventBuilder withSdkIntegration(String integration) {
        this.sdkIntegrations.add(integration);
        return this;
    }

    public EventBuilder withTag(String tagKey, String tagValue) {
        this.event.getTags().put(tagKey, tagValue);
        return this;
    }

    public EventBuilder withBreadcrumbs(List<Breadcrumb> breadcrumbs) {
        this.event.setBreadcrumbs(breadcrumbs);
        return this;
    }

    public EventBuilder withContexts(Map<String, Map<String, Object>> contexts) {
        this.event.setContexts(contexts);
        return this;
    }

    public EventBuilder withExtra(String extraName, Object extraValue) {
        this.event.getExtra().put(extraName, extraValue);
        return this;
    }

    public EventBuilder withMonitorInterface(MonitorInterface monitorInterface) {
        return this.withMonitorInterface(monitorInterface, true);
    }

    public EventBuilder withMonitorInterface(MonitorInterface monitorInterface, boolean replace) {
        if (replace || !this.event.getMonitorInterfaces().containsKey(monitorInterface.getInterfaceName())) {
            this.event.getMonitorInterfaces().put(monitorInterface.getInterfaceName(), monitorInterface);
        }
        return this;
    }

    public synchronized Event build() {
        if (this.alreadyBuilt) {
            throw new IllegalStateException("A message can't be built twice");
        }
        this.autoSetMissingValues();
        this.makeImmutable();
        this.alreadyBuilt = true;
        return this.event;
    }

    public Event getEvent() {
        return this.event;
    }

    public String toString() {
        return "EventBuilder{event=" + this.event + ", alreadyBuilt=" + this.alreadyBuilt + '}';
    }
}

