/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.connection.cache;

import android.content.Context;
import android.content.SharedPreferences;
import com.growingio.android.sdk.monitor.connection.cache.MonitorDatabase;
import com.growingio.android.sdk.monitor.event.Event;

public class DataHelper {
    private static final String MONITOR_SP_NAME = "growing_monitor_data";
    private static final String MONITOR_START_TIME = "MONITOR_START_TIME";
    private static final String MONITOR_SEND_EVENTS_COUNT = "MONITOR_SEND_EVENTS_COUNT";
    private static final long MONITOR_SEND_PERIOD = 86400000L;
    private static volatile MonitorDatabase sMonitorDb;
    private static volatile SharedPreferences sMonitorSp;

    public static void init(Context context) {
        if (sMonitorDb == null) {
            sMonitorDb = new MonitorDatabase(context);
        }
        if (sMonitorSp == null) {
            sMonitorSp = context.getSharedPreferences(MONITOR_SP_NAME, 0);
        }
    }

    public static synchronized int getSendEventsCountDaily() {
        long startTime = sMonitorSp.getLong(MONITOR_START_TIME, 0L);
        if (startTime == 0L || System.currentTimeMillis() - startTime > 86400000L) {
            sMonitorSp.edit().putLong(MONITOR_START_TIME, System.currentTimeMillis()).putInt(MONITOR_SEND_EVENTS_COUNT, 0).apply();
            return 0;
        }
        return sMonitorSp.getInt(MONITOR_SEND_EVENTS_COUNT, 0);
    }

    public static synchronized void addOneSendEventCount() {
        long startTime = sMonitorSp.getLong(MONITOR_START_TIME, 0L);
        if (startTime == 0L || System.currentTimeMillis() - startTime > 86400000L) {
            sMonitorSp.edit().putLong(MONITOR_START_TIME, System.currentTimeMillis()).putInt(MONITOR_SEND_EVENTS_COUNT, 1).apply();
        } else {
            int count = sMonitorSp.getInt(MONITOR_SEND_EVENTS_COUNT, 0) + 1;
            sMonitorSp.edit().putInt(MONITOR_SEND_EVENTS_COUNT, count).apply();
        }
    }

    public static synchronized void saveEvent(Event event) {
        sMonitorDb.saveEvent(event);
    }

    public static synchronized void deleteEvent(Event event) {
        sMonitorDb.deleteEvent(event);
    }

    public static synchronized Event getLatelyEvent(String alias) {
        return sMonitorDb.getLatelyEvent(alias);
    }
}

