/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor.analysis;

import android.text.TextUtils;
import com.growingio.android.sdk.monitor.analysis.Analysed;
import com.growingio.android.sdk.monitor.analysis.StackGroup;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Analyser {
    public static final String DEFAULT_GROUP_NAME = "unknow_group";
    private final List<String> mLibraries;
    private final String mTargetGroupName;
    private final int mMaxDeepth;
    private boolean mNeedRecordAllElements;
    private boolean mFindTarget = false;
    private boolean mFindUnknow = false;
    private int mDeepth = 0;
    private int mGroupId = 0;
    private WeakReference<Analysed> mLastAnalysed;

    private Analyser(String targetGroupName, List<String> libraries, int maxDeepth, boolean needRecordAllElements) {
        this.mLibraries = libraries;
        this.mTargetGroupName = targetGroupName;
        this.mMaxDeepth = maxDeepth;
        this.mLastAnalysed = new WeakReference<Analysed>(Analysed.EMPTY_ANALYSED);
        this.mNeedRecordAllElements = needRecordAllElements;
    }

    public Analysed analyze(Throwable throwable) {
        if (throwable == null) {
            return Analysed.EMPTY_ANALYSED;
        }
        this.mFindTarget = false;
        this.mFindUnknow = false;
        this.mDeepth = 0;
        this.mGroupId = 0;
        Analysed analysed = new Analysed(throwable);
        this.dfs(analysed, throwable);
        analysed.setIsFindTarget(this.mFindTarget);
        this.mLastAnalysed = new WeakReference<Analysed>(analysed);
        return analysed;
    }

    public Analysed getLastAnalysed() {
        Analysed lastAnalysed;
        if (this.mLastAnalysed != null && (lastAnalysed = (Analysed)this.mLastAnalysed.get()) != null) {
            return lastAnalysed;
        }
        return Analysed.EMPTY_ANALYSED;
    }

    private void dfs(Analysed analysed, Throwable throwable) {
        StackTraceElement[] elements;
        boolean hasExpectedResult;
        ++this.mDeepth;
        if (this.mDeepth > this.mMaxDeepth) {
            return;
        }
        if (throwable.getCause() != null) {
            this.dfs(analysed, throwable.getCause());
        }
        boolean bl = hasExpectedResult = !this.mNeedRecordAllElements && (this.mFindUnknow || this.mFindTarget);
        if (hasExpectedResult) {
            return;
        }
        StackGroup group = new StackGroup(this.mGroupId, DEFAULT_GROUP_NAME);
        for (StackTraceElement element : elements = throwable.getStackTrace()) {
            if (!element.getClassName().startsWith(group.getName())) {
                String newGroup = this.findGroup(element.getClassName());
                group = new StackGroup(++this.mGroupId, newGroup);
                analysed.addGroup(group);
            }
            if (!this.mFindTarget && this.mTargetGroupName.equals(group.getName())) {
                this.mFindTarget = true;
                analysed.setFirstTargetElement(element);
            }
            if (!this.mFindUnknow && DEFAULT_GROUP_NAME.equals(group.getName())) {
                this.mFindUnknow = true;
            }
            if (this.mNeedRecordAllElements) {
                group.addElement(element);
            }
            boolean bl2 = hasExpectedResult = !this.mNeedRecordAllElements && (this.mFindUnknow || this.mFindTarget);
            if (!hasExpectedResult) continue;
            return;
        }
    }

    private String findGroup(String className) {
        if (TextUtils.isEmpty((CharSequence)className)) {
            return DEFAULT_GROUP_NAME;
        }
        for (String libName : this.mLibraries) {
            if (!className.startsWith(libName)) continue;
            return libName;
        }
        return DEFAULT_GROUP_NAME;
    }

    public static class Builder {
        private List<String> mLibraries = new ArrayList<String>();
        private String mTargetGroupName = "";
        private int mMaxDeepth = 10;
        private boolean mUseDefaultLibraries = false;
        private boolean mNeedRecordAllElements = false;
        private static List<String> sDefaultLibraries = new ArrayList<String>();

        public Builder addLibrary(String library) {
            this.mLibraries.add(library);
            return this;
        }

        public Builder addLibraries(String ... libraries) {
            this.mLibraries.addAll(Arrays.asList(libraries));
            return this;
        }

        public Builder addTargetGroupName(String targetGroupName) {
            this.mTargetGroupName = targetGroupName;
            return this;
        }

        public Builder addMaxDeepth(int maxDeepth) {
            this.mMaxDeepth = maxDeepth;
            return this;
        }

        public Builder useDefaultLibraries(boolean useDefaultLibraries) {
            this.mUseDefaultLibraries = useDefaultLibraries;
            return this;
        }

        public Builder isNeedRecordAllElements(boolean isNeedRecordAllElements) {
            this.mNeedRecordAllElements = isNeedRecordAllElements;
            return this;
        }

        public Analyser build() {
            if (this.mUseDefaultLibraries) {
                return new Analyser(this.mTargetGroupName, sDefaultLibraries, this.mMaxDeepth, this.mNeedRecordAllElements);
            }
            return new Analyser(this.mTargetGroupName, this.mLibraries, this.mMaxDeepth, this.mNeedRecordAllElements);
        }

        static {
            sDefaultLibraries.add("java");
            sDefaultLibraries.add("sun");
            sDefaultLibraries.add("android");
            sDefaultLibraries.add("com.android");
            sDefaultLibraries.add("dalvik");
            sDefaultLibraries.add("okio");
            sDefaultLibraries.add("okhttp");
            sDefaultLibraries.add("com.growingio");
        }
    }
}

