/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor;

import android.support.annotation.NonNull;
import com.growingio.android.sdk.monitor.connection.Connection;
import com.growingio.android.sdk.monitor.context.Context;
import com.growingio.android.sdk.monitor.context.ContextManager;
import com.growingio.android.sdk.monitor.event.Event;
import com.growingio.android.sdk.monitor.event.EventBuilder;
import com.growingio.android.sdk.monitor.event.helper.EventBuilderHelper;
import com.growingio.android.sdk.monitor.event.helper.ShouldSendEventCallback;
import com.growingio.android.sdk.monitor.event.interfaces.ExceptionInterface;
import com.growingio.android.sdk.monitor.log.MLog;
import com.growingio.android.sdk.monitor.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class MonitorClient {
    private static final String TAG = "MonitorClient";
    protected String alias;
    protected String release;
    protected int priority = 0;
    protected String dist;
    protected String environment;
    protected Map<String, String> tags = new HashMap<String, String>();
    protected Map<String, Object> extra = new HashMap<String, Object>();
    private final Set<ShouldSendEventCallback> shouldSendEventCallbacks = new HashSet<ShouldSendEventCallback>();
    private final Connection connection;
    private final List<EventBuilderHelper> builderHelpers = new CopyOnWriteArrayList<EventBuilderHelper>();
    private final ContextManager contextManager;
    private FilterThrowableRule filterThrowableRule = new FilterThrowableRule(){

        @Override
        public boolean filterThrowable(Throwable thrown) {
            return true;
        }
    };
    private boolean isClosed = false;

    MonitorClient() {
        this.alias = null;
        this.connection = null;
        this.contextManager = null;
    }

    MonitorClient(String alias, Connection connection, ContextManager contextManager) {
        this.alias = alias;
        this.connection = connection;
        this.contextManager = contextManager;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void sendEvent(@NonNull EventBuilder eventBuilder) {
        eventBuilder.withAlias(this.alias);
        if (!Util.isNullOrEmpty(this.release)) {
            eventBuilder.withRelease(this.release.trim());
            if (!Util.isNullOrEmpty(this.dist)) {
                eventBuilder.withDist(this.dist.trim());
            }
        }
        if (!Util.isNullOrEmpty(this.environment)) {
            eventBuilder.withEnvironment(this.environment.trim());
        }
        for (Map.Entry<String, String> tagEntry : this.tags.entrySet()) {
            eventBuilder.withTag(tagEntry.getKey(), tagEntry.getValue());
        }
        for (Map.Entry<String, Object> extraEntry : this.extra.entrySet()) {
            eventBuilder.withExtra(extraEntry.getKey(), extraEntry.getValue());
        }
        this.runBuilderHelpers(eventBuilder);
        Event event = eventBuilder.build();
        this.sendEvent(event);
    }

    public void sendMessage(String message) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(message).withLevel(Event.Level.INFO);
        this.sendEvent(eventBuilder);
    }

    public void sendException(@NonNull Throwable throwable) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(throwable.getMessage()).withLevel(Event.Level.ERROR).withMonitorInterface(new ExceptionInterface(throwable));
        this.sendEvent(eventBuilder);
    }

    public void clearContext() {
        this.contextManager.clear();
    }

    public String getAlias() {
        return this.alias;
    }

    public Context getContext() {
        return this.contextManager.getContext();
    }

    public String getRelease() {
        return this.release;
    }

    public String getDist() {
        return this.dist;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setDist(String dist) {
        this.dist = dist;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void addTag(String name, String value) {
        this.tags.put(name, value);
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags == null ? new HashMap<String, String>() : tags;
    }

    public void addExtra(String name, Object value) {
        this.extra.put(name, value);
    }

    public void setExtra(Map<String, Object> extra) {
        this.extra = extra == null ? new HashMap<String, Object>() : extra;
    }

    public String toString() {
        return "MonitorClient{release='" + this.release + '\'' + ", dist='" + this.dist + '\'' + ", environment='" + this.environment + '\'' + ", tags=" + this.tags + ", extra=" + this.extra + ", connection=" + this.connection + ", builderHelpers=" + this.builderHelpers + ", contextManager=" + this.contextManager + '}';
    }

    void setFilterThrowable(FilterThrowableRule filterThrowableRule) {
        if (filterThrowableRule != null) {
            this.filterThrowableRule = filterThrowableRule;
        }
    }

    void closeConnection() {
        this.isClosed = true;
    }

    void stopSyncCachedEvent() {
        this.connection.stopSyncCachedEvent();
    }

    boolean filterThrowable(Throwable thrown) {
        if (this.isClosed) {
            return false;
        }
        return this.filterThrowableRule.filterThrowable(thrown);
    }

    void removeBuilderHelper(EventBuilderHelper builderHelper) {
        MLog.d(TAG, "Removing " + builderHelper + " from the list of builder helpers.");
        this.builderHelpers.remove(builderHelper);
    }

    void addBuilderHelper(EventBuilderHelper builderHelper) {
        MLog.d(TAG, "Adding " + builderHelper + " to the list of builder helpers.");
        this.builderHelpers.add(builderHelper);
    }

    List<EventBuilderHelper> getBuilderHelpers() {
        return Collections.unmodifiableList(this.builderHelpers);
    }

    private void runBuilderHelpers(EventBuilder eventBuilder) {
        for (EventBuilderHelper builderHelper : this.builderHelpers) {
            builderHelper.helpBuildingEvent(eventBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(@NonNull Event event) {
        for (ShouldSendEventCallback shouldSendEventCallback : this.shouldSendEventCallbacks) {
            if (shouldSendEventCallback.shouldSend(event)) continue;
            MLog.d(TAG, "Not sending Event because of ShouldSendEventCallback: " + shouldSendEventCallback);
            return;
        }
        try {
            this.connection.send(event);
        }
        catch (Exception e) {
            MLog.e(TAG, "An exception occurred while sending the event to Monitor.", e);
        }
        finally {
            this.getContext().setLastEventId(event.getId());
        }
    }

    public static interface FilterThrowableRule {
        public boolean filterThrowable(Throwable var1);
    }
}

