/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.monitor;

import com.growingio.android.sdk.monitor.MonitorClient;
import com.growingio.android.sdk.monitor.MonitorClientFactory;
import com.growingio.android.sdk.monitor.connection.Connection;
import com.growingio.android.sdk.monitor.connection.HttpConnection;
import com.growingio.android.sdk.monitor.context.ContextManager;
import com.growingio.android.sdk.monitor.context.ThreadLocalContextManager;
import com.growingio.android.sdk.monitor.dsn.Dsn;
import com.growingio.android.sdk.monitor.event.helper.ContextBuilderHelper;
import com.growingio.android.sdk.monitor.event.interfaces.ExceptionInterface;
import com.growingio.android.sdk.monitor.event.interfaces.MessageInterface;
import com.growingio.android.sdk.monitor.event.interfaces.StackTraceInterface;
import com.growingio.android.sdk.monitor.event.interfaces.UserInterface;
import com.growingio.android.sdk.monitor.jvmti.FrameCache;
import com.growingio.android.sdk.monitor.marshaller.json.ExceptionInterfaceBinding;
import com.growingio.android.sdk.monitor.marshaller.json.JsonMarshaller;
import com.growingio.android.sdk.monitor.marshaller.json.MessageInterfaceBinding;
import com.growingio.android.sdk.monitor.marshaller.json.StackTraceInterfaceBinding;
import com.growingio.android.sdk.monitor.marshaller.json.UserInterfaceBinding;
import java.util.Collection;
import java.util.Collections;

public class DefaultMonitorClientFactory
extends MonitorClientFactory {
    @Override
    public MonitorClient createMonitorClient(String alias, Dsn dsn) {
        MonitorClient monitorClient = new MonitorClient(alias, this.createConnection(alias, dsn), this.getContextManager(dsn));
        monitorClient.addBuilderHelper(new ContextBuilderHelper(monitorClient));
        return this.configureMonitorClient(monitorClient, dsn);
    }

    protected MonitorClient configureMonitorClient(MonitorClient monitorClient, Dsn dsn) {
        for (String inAppPackage : this.getInAppFrames(dsn)) {
            FrameCache.addAppPackage(inAppPackage);
        }
        return monitorClient;
    }

    protected Connection createConnection(String alias, Dsn dsn) {
        return this.createHttpConnection(alias, dsn);
    }

    protected Connection createHttpConnection(String alias, Dsn dsn) {
        JsonMarshaller marshaller = new JsonMarshaller();
        StackTraceInterfaceBinding stackTraceBinding = new StackTraceInterfaceBinding();
        stackTraceBinding.setInAppFrames(this.getInAppFrames(dsn));
        marshaller.addInterfaceBinding(StackTraceInterface.class, stackTraceBinding);
        marshaller.addInterfaceBinding(ExceptionInterface.class, new ExceptionInterfaceBinding(stackTraceBinding));
        marshaller.addInterfaceBinding(MessageInterface.class, new MessageInterfaceBinding());
        marshaller.addInterfaceBinding(UserInterface.class, new UserInterfaceBinding());
        return new HttpConnection(alias, dsn, marshaller);
    }

    protected ContextManager getContextManager(Dsn dsn) {
        return new ThreadLocalContextManager();
    }

    protected Collection<String> getInAppFrames(Dsn dsn) {
        return Collections.emptyList();
    }
}

