/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.debugger;

import com.growingio.android.debugger.DebuggerEventWrapper;
import com.growingio.android.debugger.R;
import com.growingio.android.debugger.ThreadSafeTipView;
import com.growingio.android.debugger.WebSocketHandler;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.listener.IActivityLifecycle;
import com.growingio.android.sdk.track.listener.event.ActivityLifecycleEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.modelloader.LoadDataFetcher;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.utils.ThreadUtils;
import com.growingio.android.sdk.track.webservices.WebService;
import com.growingio.android.sdk.track.webservices.message.ClientInfoMessage;
import com.growingio.android.sdk.track.webservices.message.QuitMessage;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocketListener;
import org.json.JSONException;
import org.json.JSONObject;

public class DebuggerService
implements LoadDataFetcher<WebService>,
IActivityLifecycle,
WebSocketHandler.OnWebSocketListener {
    private static final String TAG = "DebuggerService";
    private static final String WS_URL = "wsUrl";
    private static final int SOCKET_STATE_INITIALIZE = 0;
    private static final int SOCKET_STATE_READIED = 1;
    private static final int SOCKET_STATE_CLOSED = 2;
    private final OkHttpClient client;
    private final ThreadSafeTipView safeTipView;
    private final WebSocketHandler webSocketHandler;
    private Map<String, String> params;
    protected final AtomicInteger socketState = new AtomicInteger(0);

    void init(Map<String, String> params) {
        this.params = params;
    }

    public DebuggerService(OkHttpClient client) {
        DebuggerEventWrapper.get().registerDebuggerEventListener(new DebuggerEventWrapper.OnDebuggerEventListener(){

            @Override
            public void onDebuggerMessage(String message) {
                DebuggerService.this.sendMessage(message);
            }
        });
        this.client = client;
        ActivityStateProvider.get().registerActivityLifecycleListener((IActivityLifecycle)this);
        this.safeTipView = new ThreadSafeTipView(TrackerContext.get().getApplicationContext());
        this.webSocketHandler = new WebSocketHandler(this);
    }

    public void loadData(LoadDataFetcher.DataCallback<? super WebService> callback) {
        String wsUrl;
        if (this.socketState.get() == 1) {
            if (callback != null) {
                callback.onDataReady((Object)new WebService());
            }
            return;
        }
        if (this.webSocketHandler.getWebSocket() != null) {
            this.webSocketHandler.getWebSocket().cancel();
        }
        if ((wsUrl = this.params.get(WS_URL)) == null || wsUrl.isEmpty()) {
            if (callback != null) {
                callback.onLoadFailed((Exception)new NullPointerException("wsUrl is NULL, can't start WebSocketService"));
            }
            return;
        }
        Request request = new Request.Builder().url(wsUrl).build();
        this.client.newWebSocket(request, (WebSocketListener)this.webSocketHandler);
        ActivityStateProvider.get().registerActivityLifecycleListener((IActivityLifecycle)this);
        this.safeTipView.enableShow();
        ThreadUtils.postOnUiThreadDelayed((Runnable)new Runnable(){

            @Override
            public void run() {
                if (DebuggerService.this.socketState.get() < 1) {
                    Logger.e((String)DebuggerService.TAG, (String)"start WebSocketService timeout", (Object[])new Object[0]);
                    DebuggerService.this.onFailed();
                }
            }
        }, (long)10000L);
    }

    protected void sendMessage(String msg) {
        this.webSocketHandler.sendMessage(msg);
    }

    public WebService executeData() {
        this.loadData(null);
        return new WebService();
    }

    public void cleanup() {
        this.cancel();
    }

    public void cancel() {
        this.socketState.set(2);
        if (this.webSocketHandler.getWebSocket() != null) {
            this.webSocketHandler.getWebSocket().cancel();
        }
        DebuggerEventWrapper.get().end();
        this.safeTipView.dismiss();
        ActivityStateProvider.get().unregisterActivityLifecycleListener((IActivityLifecycle)this);
    }

    public Class<WebService> getDataClass() {
        return WebService.class;
    }

    @Override
    public void onReady() {
        this.sendMessage(ClientInfoMessage.createMessage().toJSONObject().toString());
        DebuggerEventWrapper.get().registerDebuggerEventListener(new DebuggerEventWrapper.OnDebuggerEventListener(){

            @Override
            public void onDebuggerMessage(String message) {
                DebuggerService.this.sendMessage(message);
            }
        });
        this.socketState.set(1);
        DebuggerEventWrapper.get().ready();
        this.safeTipView.onReady(this::exitDebugger);
    }

    @Override
    public void onMessage(String msg) {
        try {
            JSONObject message = new JSONObject(msg);
            String msgType = message.optString("msgType");
            if ("logger_open".equals(msgType)) {
                DebuggerEventWrapper.get().openLogger();
            } else if ("logger_close".equals(msgType)) {
                DebuggerEventWrapper.get().closeLogger();
            }
        }
        catch (JSONException e) {
            Logger.e((String)TAG, (Throwable)e);
        }
    }

    protected void exitDebugger() {
        this.sendMessage(new QuitMessage().toJSONObject().toString());
        this.cleanup();
    }

    @Override
    public void onFailed() {
        if (this.socketState.get() >= 2) {
            return;
        }
        this.socketState.set(2);
        this.safeTipView.setErrorMessage(R.string.growing_debugger_connected_to_web_failed);
        Logger.e((String)TAG, (String)"Start CirclerService Failed", (Object[])new Object[0]);
        this.safeTipView.showQuitedDialog(this::exitDebugger);
    }

    @Override
    public void onQuited() {
        if (this.socketState.get() >= 2) {
            return;
        }
        this.cancel();
        this.socketState.set(2);
        this.safeTipView.showQuitedDialog(this::exitDebugger);
    }

    public AtomicInteger getSocketState() {
        return this.socketState;
    }

    public void onActivityLifecycle(ActivityLifecycleEvent event) {
        if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_RESUMED) {
            this.safeTipView.show(event.getActivity());
        } else if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_PAUSED) {
            this.safeTipView.removeOnly();
        }
    }
}

