/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.database;

import android.content.ContentValues;
import android.net.Uri;
import com.growingio.android.sdk.TrackerContext;
import java.io.File;

public class EventDataTable {
    private static final int DATABASE_VERSION = 1;
    public static final String TABLE_EVENTS = "events";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_CREATE_TIME = "_created";
    public static final String COLUMN_LAST_MODIFIED = "_modified";
    public static final String COLUMN_DATA = "_data";
    public static final String COLUMN_EVENT_TYPE = "_event_type";
    public static final String COLUMN_POLICY = "_policy";
    public static final String CREATE_TABLE_EVENTS = "CREATE TABLE IF NOT EXISTS events(\n_id INTEGER PRIMARY KEY AUTOINCREMENT,\n_created INTEGER NOT NULL, \n_modified INTEGER NOT NULL, \n_data BLOB NOT NULL, \n_event_type TEXT NOT NULL, \n_policy INTEGER NOT NULL \n);";
    public static final String DROP_TABLE_EVENTS = "DROP TABLE IF EXISTS events;";

    private EventDataTable() {
    }

    public static Uri getContentUri() {
        return Uri.parse((String)("content://" + TrackerContext.get().getPackageName() + "." + "EventDataContentProvider" + File.separator + TABLE_EVENTS));
    }

    public static ContentValues putValues(byte[] data, String eventType, Integer policy) {
        long current = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put(COLUMN_CREATE_TIME, Long.valueOf(current));
        contentValues.put(COLUMN_LAST_MODIFIED, Long.valueOf(current));
        contentValues.put(COLUMN_DATA, data);
        contentValues.put(COLUMN_EVENT_TYPE, eventType);
        contentValues.put(COLUMN_POLICY, policy);
        return contentValues;
    }
}

