/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.database;

import android.annotation.SuppressLint;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteFullException;
import android.net.Uri;
import android.os.RemoteException;
import com.growingio.android.database.DeprecatedEventSQLite;
import com.growingio.android.database.EventDataTable;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.EventDbResult;
import com.growingio.android.sdk.track.middleware.GEvent;
import com.growingio.android.sdk.track.middleware.format.EventByteArray;
import com.growingio.android.sdk.track.middleware.format.EventFormatData;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import java.util.ArrayList;
import java.util.List;

public class EventDataManager {
    private static final String TAG = "EventDataManager";
    private static final long EVENT_VALID_PERIOD_MILLS = 604800000L;
    private final Context context;
    private final String eventsInfoAuthority;
    private boolean ignoreOperations = false;

    EventDataManager(Context context) {
        this.context = context;
        this.eventsInfoAuthority = context.getPackageName() + "." + "EventDataContentProvider";
        DeprecatedEventSQLite deprecatedEventSQLite = new DeprecatedEventSQLite(context, this);
        deprecatedEventSQLite.migrateEvents();
    }

    private EventByteArray formatData(EventFormatData data) {
        ModelLoader modelLoader = TrackerContext.get().getRegistry().getModelLoader(EventFormatData.class, EventByteArray.class);
        if (modelLoader == null) {
            Logger.e((String)TAG, (String)"please register eventformat component first", (Object[])new Object[0]);
            return null;
        }
        ModelLoader.LoadData loadData = modelLoader.buildLoadData((Object)data);
        return (EventByteArray)loadData.fetcher.executeData();
    }

    int insertEvents(List<GEvent> events) {
        int count = 0;
        for (GEvent event : events) {
            Uri uri = this.insertEvent(event);
            if (uri == null) continue;
            ++count;
        }
        return count;
    }

    Uri insertEvent(GEvent gEvent) {
        if (this.ignoreOperations) {
            return null;
        }
        try {
            ContentResolver contentResolver = this.context.getContentResolver();
            Uri uri = EventDataTable.getContentUri();
            EventByteArray data = this.formatData(EventFormatData.format((GEvent)gEvent));
            if (data != null && data.getBodyData() != null) {
                ContentValues contentValues = EventDataTable.putValues(data.getBodyData(), gEvent.getEventType(), gEvent.getSendPolicy());
                return contentResolver.insert(uri, contentValues);
            }
        }
        catch (SQLiteFullException e) {
            this.onDiskFull(e);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (Throwable)e, (String)"insertEvent failed", (Object[])new Object[0]);
        }
        return null;
    }

    int removeOverdueEvents() {
        if (this.ignoreOperations) {
            return -1;
        }
        try {
            long current = System.currentTimeMillis();
            long sevenDayAgo = current - 604800000L;
            ContentResolver contentResolver = this.context.getContentResolver();
            Uri uri = EventDataTable.getContentUri();
            int deleteNum = contentResolver.delete(uri, "_created<=" + sevenDayAgo, null);
            Logger.e((String)TAG, (String)"removeOverdueEvents: deleteNum: %d", (Object[])new Object[]{deleteNum});
            return deleteNum;
        }
        catch (SQLiteFullException e) {
            this.onDiskFull(e);
            return -1;
        }
        catch (Exception e) {
            Logger.e((String)TAG, (Throwable)e, (String)"removeOverdueEvents failed", (Object[])new Object[0]);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryEvents(int policy, int limit, EventDbResult dbResult) {
        if (this.ignoreOperations) {
            dbResult.setSuccess(false);
            return;
        }
        long lastId = -1L;
        ArrayList<byte[]> queryList = new ArrayList<byte[]>();
        ContentProviderClient client = this.context.getContentResolver().acquireContentProviderClient(this.eventsInfoAuthority);
        try (Cursor cursor = this.queryEvents(client, policy, limit);){
            int count = 0;
            while (cursor.moveToNext()) {
                byte[] data;
                ++count;
                String eventType = cursor.getString(cursor.getColumnIndexOrThrow("_event_type"));
                dbResult.setEventType(eventType);
                if (cursor.isLast()) {
                    lastId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                    dbResult.setLastId(lastId);
                }
                if ((data = cursor.getBlob(cursor.getColumnIndexOrThrow("_data"))) != null) {
                    queryList.add(data);
                    continue;
                }
                long delId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                this.removeEventById(client, delId);
            }
            EventByteArray result = this.formatData(EventFormatData.merge(queryList));
            if (result != null && result.getBodyData() != null) {
                dbResult.setSum(count);
                dbResult.setSuccess(true);
                dbResult.setData(result.getBodyData());
                dbResult.setMediaType(result.getMediaType());
            }
        }
        catch (SQLiteFullException e) {
            dbResult.setSuccess(false);
            this.onDiskFull(e);
        }
        catch (Throwable t) {
            dbResult.setSuccess(false);
            Logger.e((String)TAG, (Throwable)t, (String)t.getMessage(), (Object[])new Object[0]);
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryEventsAndDelete(int policy, int limit, EventDbResult dbResult) {
        if (this.ignoreOperations) {
            dbResult.setSuccess(false);
            return;
        }
        ContentProviderClient client = this.context.getContentResolver().acquireContentProviderClient(this.eventsInfoAuthority);
        ArrayList<byte[]> queryList = new ArrayList<byte[]>();
        try (Cursor cursor = this.queryEvents(client, policy, limit);){
            int count = 0;
            while (cursor.moveToNext()) {
                byte[] data;
                ++count;
                if (cursor.isLast()) {
                    cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                }
                if ((data = cursor.getBlob(cursor.getColumnIndexOrThrow("_data"))) != null) {
                    queryList.add(data);
                }
                long delId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                this.removeEventById(client, delId);
            }
            EventByteArray result = this.formatData(EventFormatData.merge(queryList));
            if (result != null && result.getBodyData() != null) {
                dbResult.setSum(count);
                dbResult.setSuccess(true);
                dbResult.setData(result.getBodyData());
                dbResult.setMediaType(result.getMediaType());
            }
        }
        catch (SQLiteFullException e) {
            this.onDiskFull(e);
        }
        catch (Throwable t) {
            Logger.e((String)TAG, (Throwable)t, (String)t.getMessage(), (Object[])new Object[0]);
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    @SuppressLint(value={"Recycle"})
    private Cursor queryEvents(ContentProviderClient client, int policy, int limit) throws RemoteException {
        Uri uri = EventDataTable.getContentUri();
        String subSelect = "SELECT _event_type FROM events WHERE _policy=" + policy + " LIMIT 1";
        String sql = "SELECT _id, _data, _event_type FROM events WHERE _event_type=(" + subSelect + ") AND " + "_policy" + "=" + policy + " LIMIT " + limit + ";";
        if (client == null) {
            ContentResolver contentResolver = this.context.getContentResolver();
            return contentResolver.query(uri, null, sql, null, "rawQuery");
        }
        return client.query(uri, null, sql, null, "rawQuery");
    }

    private void removeEventById(ContentProviderClient client, long id) throws RemoteException {
        Uri uri = EventDataTable.getContentUri();
        if (client == null) {
            ContentResolver contentResolver = this.context.getContentResolver();
            contentResolver.delete(uri, "_id=?", new String[]{String.valueOf(id)});
        } else {
            client.delete(uri, "_id=?", new String[]{String.valueOf(id)});
        }
    }

    int removeEvents(long lastId, int policy, String eventType) {
        if (this.ignoreOperations) {
            return -1;
        }
        try {
            ContentResolver contentResolver = this.context.getContentResolver();
            Uri uri = EventDataTable.getContentUri();
            int sum = contentResolver.delete(uri, "_id<=? AND _event_type=? AND _policy=?", new String[]{String.valueOf(lastId), eventType, String.valueOf(policy)});
            Logger.d((String)TAG, (String)"removeEvents: deleteNum: %d", (Object[])new Object[]{sum});
            return sum;
        }
        catch (SQLiteFullException e) {
            this.onDiskFull(e);
            return -1;
        }
        catch (Exception e) {
            Logger.e((String)TAG, (Throwable)e, (String)"removeEvents failed", (Object[])new Object[0]);
            return -1;
        }
    }

    void removeAllEvents() {
        if (this.ignoreOperations) {
            return;
        }
        try {
            ContentResolver contentResolver = this.context.getContentResolver();
            Uri uri = EventDataTable.getContentUri();
            contentResolver.delete(uri, null, null);
        }
        catch (SQLiteFullException e) {
            this.onDiskFull(e);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (Throwable)e, (String)"removeAllEvents failed", (Object[])new Object[0]);
        }
    }

    private void onDiskFull(SQLiteFullException e) {
        Logger.e((String)TAG, (Throwable)e, (String)"Disk full, all operations will be ignored", (Object[])new Object[0]);
        this.ignoreOperations = true;
    }
}

