/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.circler.screenshot;

import org.json.JSONException;
import org.json.JSONObject;

class ViewElement {
    private static final String NODE_TYPE_BUTTON = "button";
    private static final String NODE_TYPE_WEB_VIEW = "webView";
    private final String mXpath;
    private final String mParentXPath;
    private final int mLeft;
    private final int mTop;
    private final int mWidth;
    private final int mHeight;
    private final String mNodeType;
    private final String mContent;
    private final String mPage;
    private final int mZLevel;
    private final int mIndex;
    private final JSONObject mWebView;

    private ViewElement(Builder builder) {
        this.mXpath = builder.mXpath;
        this.mParentXPath = builder.mParentXPath;
        this.mLeft = builder.mLeft;
        this.mTop = builder.mTop;
        this.mWidth = builder.mWidth;
        this.mHeight = builder.mHeight;
        this.mNodeType = builder.mNodeType;
        this.mContent = builder.mContent;
        this.mPage = builder.mPage;
        this.mZLevel = builder.mZLevel;
        this.mIndex = builder.mIndex;
        this.mWebView = builder.mWebView;
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("xpath", (Object)this.mXpath);
            json.put("parentXPath", (Object)this.mParentXPath);
            json.put("left", this.mLeft);
            json.put("top", this.mTop);
            json.put("width", this.mWidth);
            json.put("height", this.mHeight);
            json.put("nodeType", (Object)this.mNodeType);
            json.put("content", (Object)this.mContent);
            json.put("page", (Object)this.mPage);
            json.put("zLevel", this.mZLevel);
            if (this.mIndex > -1) {
                json.put("index", this.mIndex);
            }
            json.put(NODE_TYPE_WEB_VIEW, (Object)this.mWebView);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    static final class Builder {
        private String mXpath;
        private String mParentXPath;
        private int mLeft;
        private int mTop;
        private int mWidth;
        private int mHeight;
        private String mNodeType;
        private String mContent;
        private String mPage;
        private int mZLevel;
        private int mIndex;
        private JSONObject mWebView;

        Builder() {
        }

        public Builder setXpath(String xpath) {
            this.mXpath = xpath;
            return this;
        }

        public Builder setParentXPath(String parentXPath) {
            this.mParentXPath = parentXPath;
            return this;
        }

        public Builder setLeft(int left) {
            this.mLeft = left;
            return this;
        }

        public Builder setTop(int top) {
            this.mTop = top;
            return this;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder setNodeType(String nodeType) {
            this.mNodeType = nodeType;
            return this;
        }

        public Builder setContent(String content) {
            this.mContent = content;
            return this;
        }

        public Builder setPage(String page) {
            this.mPage = page;
            return this;
        }

        public Builder setZLevel(int zLevel) {
            this.mZLevel = zLevel;
            return this;
        }

        public Builder setIndex(int index) {
            this.mIndex = index;
            return this;
        }

        public Builder setWebView(JSONObject webView) {
            this.mWebView = webView;
            return this;
        }

        public ViewElement build() {
            return new ViewElement(this);
        }
    }
}

