/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.circler.screenshot;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.view.View;
import com.growingio.android.circler.screenshot.CircleScreenshot;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.async.Callback;
import com.growingio.android.sdk.track.listener.ListenerContainer;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.modelloader.data.HybridDom;
import com.growingio.android.sdk.track.modelloader.data.HybridJson;
import com.growingio.android.sdk.track.utils.DeviceUtil;
import com.growingio.android.sdk.track.view.DecorView;
import com.growingio.android.sdk.track.view.ScreenshotUtil;
import com.growingio.android.sdk.track.view.ViewTreeStatusProvider;
import com.growingio.android.sdk.track.view.WindowHelper;
import com.growingio.android.sdk.track.webservices.widget.TipView;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;

public class ScreenshotProvider
extends ListenerContainer<OnScreenshotRefreshedListener, CircleScreenshot> {
    private static final String TAG = "ScreenshotProvider";
    private static final float SCREENSHOT_STANDARD_WIDTH = 720.0f;
    private static final long MIN_REFRESH_INTERVAL = 500L;
    private long lastSendTime = System.currentTimeMillis();
    private final float mScale;
    private final Handler mHandler;
    private final Runnable mRefreshScreenshotRunnable = this::dispatchScreenshot;
    private ModelLoader<HybridDom, HybridJson> modelLoader;
    private long mSnapshotKey = 0L;

    private ScreenshotProvider() {
        DisplayMetrics metrics = DeviceUtil.getDisplayMetrics((Context)TrackerContext.get().getApplicationContext());
        this.mScale = 720.0f / (float)Math.min(metrics.widthPixels, metrics.heightPixels);
        HandlerThread mHandlerThread = new HandlerThread(TAG);
        mHandlerThread.start();
        this.mHandler = new Handler(mHandlerThread.getLooper());
        ViewTreeStatusProvider.get().register(changedEvent -> {
            if (System.currentTimeMillis() - this.lastSendTime >= 1000L) {
                this.lastSendTime = System.currentTimeMillis();
                this.mHandler.post(this::dispatchScreenshot);
            } else {
                this.refreshScreenshot();
            }
        });
        this.getHybridModelLoader();
    }

    ModelLoader<HybridDom, HybridJson> getHybridModelLoader() {
        if (this.modelLoader == null) {
            this.modelLoader = TrackerContext.get().getRegistry().getModelLoader(HybridDom.class, HybridJson.class);
            if (this.modelLoader != null) {
                this.modelLoader.buildLoadData((Object)new HybridDom((HybridDom.OnDomChangedListener)(HybridDom.OnDomChangedListener)LambdaMetafactory.metafactory(null, null, null, ()V, refreshScreenshot(), ()V)((ScreenshotProvider)this))).fetcher.executeData();
            }
        }
        return this.modelLoader;
    }

    private void dispatchScreenshot() {
        if (this.getListenerCount() == 0) {
            return;
        }
        List decorViews = WindowHelper.get().getTopActivityViews();
        if (decorViews.isEmpty()) {
            return;
        }
        for (int i = decorViews.size() - 1; i >= 0; --i) {
            if (!(((DecorView)decorViews.get(i)).getView() instanceof TipView)) continue;
            decorViews.remove(i);
            break;
        }
        View topView = ((DecorView)decorViews.get(decorViews.size() - 1)).getView();
        topView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
            }

            public void onViewDetachedFromWindow(View v) {
                ScreenshotProvider.this.refreshScreenshot();
            }
        });
        topView.post(() -> {
            try {
                String screenshotBase64 = ScreenshotUtil.getScreenshotBase64((float)this.mScale);
                this.sendScreenshotRefreshed(screenshotBase64, this.mScale);
            }
            catch (IOException e) {
                Logger.e((String)TAG, (Throwable)e);
            }
        });
    }

    public void refreshScreenshot() {
        this.mHandler.removeCallbacks(this.mRefreshScreenshotRunnable);
        this.mHandler.postDelayed(this.mRefreshScreenshotRunnable, 500L);
    }

    public static ScreenshotProvider get() {
        return SingleInstance.INSTANCE;
    }

    protected void singleAction(OnScreenshotRefreshedListener listener, CircleScreenshot action) {
        listener.onScreenshotRefreshed(action);
    }

    public void registerScreenshotRefreshedListener(OnScreenshotRefreshedListener listener) {
        this.register(listener);
        this.refreshScreenshot();
    }

    public void unregisterScreenshotRefreshedListener(OnScreenshotRefreshedListener listener) {
        this.unregister(listener);
    }

    public void sendScreenshotRefreshed(String screenshotBase64, float scale) {
        this.lastSendTime = System.currentTimeMillis();
        CircleScreenshot.Builder builder = new CircleScreenshot.Builder().setScale(scale).setScreenshot(screenshotBase64).setSnapshotKey(this.mSnapshotKey++);
        builder.build(new Callback<CircleScreenshot>(){

            public void onSuccess(CircleScreenshot result) {
                Logger.d((String)ScreenshotProvider.TAG, (String)"Create circle screenshot successfully", (Object[])new Object[0]);
                ScreenshotProvider.this.sendScreenshot(result);
            }

            public void onFailed() {
                Logger.e((String)ScreenshotProvider.TAG, (String)"Create circle screenshot failed", (Object[])new Object[0]);
            }
        });
    }

    public void sendScreenshot(CircleScreenshot result) {
        if (result != null) {
            this.dispatchActions(result);
        }
    }

    public static interface OnScreenshotRefreshedListener {
        public void onScreenshotRefreshed(CircleScreenshot var1);
    }

    private static class SingleInstance {
        private static final ScreenshotProvider INSTANCE = new ScreenshotProvider();

        private SingleInstance() {
        }
    }
}

