/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.circler.screenshot;

import org.json.JSONException;
import org.json.JSONObject;

class PageElement {
    private final String mPath;
    private final String mTitle;
    private final int mLeft;
    private final int mTop;
    private final int mWidth;
    private final int mHeight;
    private final boolean mIsIgnored;

    private PageElement(Builder builder) {
        this.mPath = builder.mPath;
        this.mTitle = builder.mTitle;
        this.mLeft = builder.mLeft;
        this.mTop = builder.mTop;
        this.mWidth = builder.mWidth;
        this.mHeight = builder.mHeight;
        this.mIsIgnored = builder.mIsIgnored;
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("path", (Object)this.mPath);
            json.put("title", (Object)this.mTitle);
            json.put("left", this.mLeft);
            json.put("top", this.mTop);
            json.put("width", this.mWidth);
            json.put("height", this.mHeight);
            json.put("isIgnored", this.mIsIgnored);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    static final class Builder {
        private String mPath;
        private String mTitle;
        private int mLeft;
        private int mTop;
        private int mWidth;
        private int mHeight;
        private boolean mIsIgnored;

        Builder() {
        }

        public Builder setPath(String path) {
            this.mPath = path;
            return this;
        }

        public Builder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public Builder setLeft(int left) {
            this.mLeft = left;
            return this;
        }

        public Builder setTop(int top) {
            this.mTop = top;
            return this;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public Builder setIgnored(boolean ignored) {
            this.mIsIgnored = ignored;
            return this;
        }

        public PageElement build() {
            return new PageElement(this);
        }
    }
}

