/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.circler.screenshot;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import com.growingio.android.circler.screenshot.PageElement;
import com.growingio.android.circler.screenshot.ScreenshotProvider;
import com.growingio.android.circler.screenshot.ViewElement;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.autotrack.page.Page;
import com.growingio.android.sdk.autotrack.page.PageProvider;
import com.growingio.android.sdk.autotrack.view.ViewAttributeUtil;
import com.growingio.android.sdk.autotrack.view.ViewHelper;
import com.growingio.android.sdk.autotrack.view.ViewNode;
import com.growingio.android.sdk.autotrack.view.ViewUtil;
import com.growingio.android.sdk.track.async.Callback;
import com.growingio.android.sdk.track.modelloader.LoadDataFetcher;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.modelloader.data.HybridDom;
import com.growingio.android.sdk.track.modelloader.data.HybridJson;
import com.growingio.android.sdk.track.utils.ClassExistHelper;
import com.growingio.android.sdk.track.utils.DeviceUtil;
import com.growingio.android.sdk.track.view.DecorView;
import com.growingio.android.sdk.track.view.WindowHelper;
import com.growingio.android.sdk.track.webservices.widget.TipView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CircleScreenshot {
    private static final String MSG_TYPE = "refreshScreenshot";
    private final int mScreenWidth;
    private final int mScreenHeight;
    private final float mScale;
    private final String mScreenshot;
    private final String mMsgType;
    private final long mSnapshotKey;
    private final List<ViewElement> mElements;
    private final List<PageElement> mPages;

    public CircleScreenshot(Builder builder) {
        this.mMsgType = MSG_TYPE;
        this.mScreenWidth = builder.mScreenWidth;
        this.mScreenHeight = builder.mScreenHeight;
        this.mScale = builder.mScale;
        this.mScreenshot = builder.mScreenshot;
        this.mSnapshotKey = builder.mSnapshotKey;
        this.mElements = Collections.unmodifiableList(builder.mViewElements);
        this.mPages = Collections.unmodifiableList(builder.mPages);
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("screenWidth", this.mScreenWidth);
            json.put("screenHeight", this.mScreenHeight);
            json.put("scale", (double)this.mScale);
            json.put("screenshot", (Object)this.mScreenshot);
            json.put("msgType", (Object)this.mMsgType);
            json.put("snapshotKey", this.mSnapshotKey);
            JSONArray elementArray = new JSONArray();
            for (ViewElement element : this.mElements) {
                elementArray.put((Object)element.toJSONObject());
            }
            json.put("elements", (Object)elementArray);
            JSONArray pageArray = new JSONArray();
            for (PageElement page : this.mPages) {
                pageArray.put((Object)page.toJSONObject());
            }
            json.put("pages", (Object)pageArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static final class Builder {
        private int mScreenWidth;
        private int mScreenHeight;
        private float mScale;
        private String mScreenshot;
        private long mSnapshotKey;
        private final List<ViewElement> mViewElements = new ArrayList<ViewElement>();
        private final List<PageElement> mPages = new ArrayList<PageElement>();
        private final AtomicInteger mScreenLock = new AtomicInteger(0);
        private int mViewCount = 0;
        private Callback<CircleScreenshot> mScreenshotResultCallback;

        public Builder setScale(float scale) {
            this.mScale = scale;
            return this;
        }

        public Builder setScreenshot(String screenshot) {
            this.mScreenshot = screenshot;
            return this;
        }

        public Builder setSnapshotKey(long snapshotKey) {
            this.mSnapshotKey = snapshotKey;
            return this;
        }

        public void build(Callback<CircleScreenshot> callback) {
            List decorViews = WindowHelper.get().getTopActivityViews();
            this.build(decorViews, callback);
        }

        public void build(List<DecorView> decorViews, Callback<CircleScreenshot> callback) {
            if (callback == null) {
                return;
            }
            if (decorViews == null || decorViews.isEmpty()) {
                this.callResultOnFailed();
                return;
            }
            this.mScreenshotResultCallback = callback;
            DisplayMetrics displayMetrics = DeviceUtil.getDisplayMetrics((Context)TrackerContext.get().getApplicationContext());
            this.mScreenWidth = displayMetrics.widthPixels;
            this.mScreenHeight = displayMetrics.heightPixels;
            this.mScreenLock.incrementAndGet();
            for (DecorView decorView : decorViews) {
                if (decorView.getView() instanceof TipView || this.isViewInvisible(decorView.getView())) continue;
                this.checkView2PageElement(decorView.getView());
                this.checkView2ViewElement(decorView.getView());
            }
            this.callResultOnSuccess();
        }

        private ViewElement.Builder createViewElementBuilder(ViewNode viewNode) {
            ViewElement.Builder builder = new ViewElement.Builder();
            int[] location = new int[2];
            viewNode.getView().getLocationOnScreen(location);
            return builder.setLeft(location[0]).setTop(location[1]).setHeight(viewNode.getView().getHeight()).setWidth(viewNode.getView().getWidth()).setContent(viewNode.getViewContent()).setNodeType(viewNode.getNodeType()).setPage(PageProvider.get().findPage(viewNode.getView()).path()).setParentXPath(viewNode.getClickableParentXPath()).setXpath(viewNode.getXPath()).setIndex(viewNode.getIndex()).setZLevel(this.mViewCount++);
        }

        private void checkView2ViewElement(View view) {
            ViewNode topViewNode = ViewHelper.getTopViewNode((View)view, null);
            this.traverseViewNode(topViewNode);
        }

        private void traverseViewNode(ViewNode viewNode) {
            ViewGroup viewGroup;
            if (this.isViewInvisible(viewNode.getView())) {
                return;
            }
            if (!this.disposeWebView(viewNode) && ViewUtil.canCircle((View)viewNode.getView())) {
                this.mViewElements.add(this.createViewElementBuilder(viewNode).build());
            }
            if (viewNode.getView() instanceof ViewGroup && (viewGroup = (ViewGroup)viewNode.getView()).getChildCount() > 0) {
                for (int index = 0; index < viewGroup.getChildCount(); ++index) {
                    ViewNode childViewNode = viewNode.appendNode(viewGroup.getChildAt(index), index);
                    this.traverseViewNode(childViewNode);
                }
            }
        }

        private boolean disposeWebView(final ViewNode viewNode) {
            if (ClassExistHelper.isWebView((Object)viewNode.getView())) {
                ModelLoader<HybridDom, HybridJson> modelLoader = ScreenshotProvider.get().getHybridModelLoader();
                if (modelLoader == null) {
                    return false;
                }
                this.mScreenLock.incrementAndGet();
                LoadDataFetcher loadDataFetcher = (LoadDataFetcher)modelLoader.buildLoadData((Object)new HybridDom((View)viewNode.getView())).fetcher;
                loadDataFetcher.loadData((LoadDataFetcher.DataCallback)new LoadDataFetcher.DataCallback<HybridJson>(){

                    public void onDataReady(HybridJson data) {
                        ViewElement.Builder elementBuilder = this.createViewElementBuilder(viewNode);
                        mViewElements.add(elementBuilder.setWebView(data.getJsonObject()).build());
                        this.callResultOnSuccess();
                    }

                    public void onLoadFailed(Exception e) {
                        this.callResultOnSuccess();
                    }
                });
                return true;
            }
            return false;
        }

        private void callResultOnSuccess() {
            if (this.mScreenLock.decrementAndGet() <= 0 && this.mScreenshotResultCallback != null) {
                this.mScreenshotResultCallback.onSuccess((Object)new CircleScreenshot(this));
            }
        }

        private void callResultOnFailed() {
            if (this.mScreenshotResultCallback != null) {
                this.mScreenshotResultCallback.onFailed();
            }
        }

        private void checkView2PageElement(View view) {
            ViewGroup viewGroup;
            Page viewPage = ViewAttributeUtil.getViewPage((View)view);
            if (viewPage != null) {
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                this.mPages.add(new PageElement.Builder().setTitle(viewPage.getTitle()).setPath(viewPage.path()).setIgnored(viewPage.isIgnored()).setHeight(view.getHeight()).setWidth(view.getWidth()).setLeft(location[0]).setTop(location[1]).build());
            }
            if (view instanceof ViewGroup && (viewGroup = (ViewGroup)view).getChildCount() > 0) {
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    this.checkView2PageElement(viewGroup.getChildAt(i));
                }
            }
        }

        private boolean isViewInvisible(View view) {
            return view.getVisibility() == 8 || view.getWidth() <= 0 || view.getHeight() <= 0;
        }
    }
}

