/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.circler;

import android.text.TextUtils;
import android.util.Log;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.utils.ThreadUtils;
import com.growingio.android.sdk.track.webservices.message.ReadyMessage;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.json.JSONException;
import org.json.JSONObject;

class WebSocketHandler
extends WebSocketListener {
    private final OnWebSocketListener webSocketListener;
    private WebSocket webSocket;
    private static final String TAG = "WebSocketHandler";

    WebSocketHandler(OnWebSocketListener webSocketListener) {
        this.webSocketListener = webSocketListener;
    }

    public void sendMessage(String msg) {
        Log.d((String)"WebSocket", (String)msg);
        if (this.webSocket != null) {
            this.webSocket.send(msg);
        }
    }

    public void onOpen(WebSocket webSocket, Response response) {
        Logger.d((String)TAG, (String)"Created webSocket successfully", (Object[])new Object[0]);
        if (webSocket.send(ReadyMessage.createMessage().toJSONObject().toString())) {
            this.webSocket = webSocket;
        } else {
            Logger.e((String)TAG, (String)"send ready message failed", (Object[])new Object[0]);
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebSocketHandler.this.webSocketListener.onFailed();
                }
            });
        }
    }

    public void onMessage(WebSocket webSocket, final String text) {
        if (TextUtils.isEmpty((CharSequence)text) || TextUtils.isEmpty((CharSequence)text.trim())) {
            return;
        }
        Logger.d((String)TAG, (String)("Received message is " + text), (Object[])new Object[0]);
        try {
            JSONObject message = new JSONObject(text);
            String msgType = message.optString("msgType");
            if ("ready".equals(msgType)) {
                Logger.d((String)TAG, (String)"Web is ready", (Object[])new Object[0]);
                ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebSocketHandler.this.webSocketListener.onReady();
                    }
                });
                return;
            }
            if ("quit".equals(msgType)) {
                Logger.d((String)TAG, (String)"Web is quited", (Object[])new Object[0]);
                ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebSocketHandler.this.webSocketListener.onQuited();
                    }
                });
                return;
            }
        }
        catch (JSONException e) {
            Logger.e((String)TAG, (Throwable)e);
        }
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WebSocketHandler.this.webSocketListener.onMessage(text);
            }
        });
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        Logger.e((String)TAG, (String)"webSocket on onClosed, reason: $reason", (Object[])new Object[0]);
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WebSocketHandler.this.webSocketListener.onQuited();
            }
        });
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        Logger.e((String)TAG, (Throwable)t, (String)"webSocket on onFailure, reason: ", (Object[])new Object[0]);
        ThreadUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                WebSocketHandler.this.webSocketListener.onFailed();
            }
        });
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    static interface OnWebSocketListener {
        public void onReady();

        public void onQuited();

        public void onFailed();

        public void onMessage(String var1);
    }
}

