/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.circler;

import com.growingio.android.circler.R;
import com.growingio.android.circler.ThreadSafeTipView;
import com.growingio.android.circler.WebSocketHandler;
import com.growingio.android.circler.screenshot.CircleScreenshot;
import com.growingio.android.circler.screenshot.ScreenshotProvider;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.listener.IActivityLifecycle;
import com.growingio.android.sdk.track.listener.event.ActivityLifecycleEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.modelloader.LoadDataFetcher;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.utils.ThreadUtils;
import com.growingio.android.sdk.track.webservices.WebService;
import com.growingio.android.sdk.track.webservices.message.ClientInfoMessage;
import com.growingio.android.sdk.track.webservices.message.QuitMessage;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocketListener;

public class CirclerService
implements LoadDataFetcher<WebService>,
IActivityLifecycle,
ScreenshotProvider.OnScreenshotRefreshedListener,
WebSocketHandler.OnWebSocketListener {
    private static final String TAG = "CirclerService";
    private static final String WS_URL = "wsUrl";
    private static final int SOCKET_STATE_INITIALIZE = 0;
    private static final int SOCKET_STATE_READIED = 1;
    private static final int SOCKET_STATE_CLOSED = 2;
    private final OkHttpClient client;
    private final ThreadSafeTipView safeTipView;
    private final WebSocketHandler webSocketHandler;
    private Map<String, String> params;
    protected final AtomicInteger socketState = new AtomicInteger(0);

    void init(Map<String, String> params) {
        this.params = params;
    }

    public CirclerService(OkHttpClient client) {
        this.client = client;
        ActivityStateProvider.get().registerActivityLifecycleListener((IActivityLifecycle)this);
        this.safeTipView = new ThreadSafeTipView(TrackerContext.get().getApplicationContext());
        this.webSocketHandler = new WebSocketHandler(this);
    }

    public void loadData(LoadDataFetcher.DataCallback<? super WebService> callback) {
        String wsUrl;
        if (this.socketState.get() == 1) {
            if (callback != null) {
                callback.onDataReady((Object)new WebService());
            }
            return;
        }
        if (this.webSocketHandler.getWebSocket() != null) {
            this.webSocketHandler.getWebSocket().cancel();
        }
        if ((wsUrl = this.params.get(WS_URL)) == null || wsUrl.isEmpty()) {
            if (callback != null) {
                callback.onLoadFailed((Exception)new NullPointerException("wsUrl is NULL, can't start WebSocketService"));
            }
            return;
        }
        Request request = new Request.Builder().url(wsUrl).build();
        this.client.newWebSocket(request, (WebSocketListener)this.webSocketHandler);
        ActivityStateProvider.get().registerActivityLifecycleListener((IActivityLifecycle)this);
        this.safeTipView.enableShow();
        ThreadUtils.postOnUiThreadDelayed((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CirclerService.this.socketState.get() < 1) {
                    Logger.e((String)CirclerService.TAG, (String)"start WebSocketService timeout", (Object[])new Object[0]);
                    CirclerService.this.onFailed();
                }
            }
        }, (long)10000L);
    }

    protected void sendMessage(String msg) {
        this.webSocketHandler.sendMessage(msg);
    }

    public WebService executeData() {
        this.loadData(null);
        return new WebService();
    }

    public void cleanup() {
        this.cancel();
    }

    public void cancel() {
        this.socketState.set(2);
        if (this.webSocketHandler.getWebSocket() != null) {
            this.webSocketHandler.getWebSocket().cancel();
        }
        ScreenshotProvider.get().unregisterScreenshotRefreshedListener(this);
        this.safeTipView.dismiss();
        ActivityStateProvider.get().unregisterActivityLifecycleListener((IActivityLifecycle)this);
    }

    public Class<WebService> getDataClass() {
        return WebService.class;
    }

    @Override
    public void onReady() {
        this.sendMessage(ClientInfoMessage.createMessage().toJSONObject().toString());
        this.socketState.set(1);
        ScreenshotProvider.get().registerScreenshotRefreshedListener(this);
        this.safeTipView.onReady(new ThreadSafeTipView.OnExitListener(){

            @Override
            public void onExitDebugger() {
                CirclerService.this.exitCircler();
            }
        });
    }

    @Override
    public void onMessage(String msg) {
    }

    protected void exitCircler() {
        this.sendMessage(new QuitMessage().toJSONObject().toString());
        this.cleanup();
    }

    @Override
    public void onFailed() {
        if (this.socketState.get() >= 2) {
            return;
        }
        this.socketState.set(2);
        this.safeTipView.setErrorMessage(R.string.growing_circler_connected_to_web_failed);
        Logger.e((String)TAG, (String)"Start CirclerService Failed", (Object[])new Object[0]);
        this.safeTipView.showQuitedDialog(this::exitCircler);
    }

    @Override
    public void onQuited() {
        if (this.socketState.get() >= 2) {
            return;
        }
        this.cancel();
        this.socketState.set(2);
        this.safeTipView.showQuitedDialog(this::exitCircler);
    }

    @Override
    public void onScreenshotRefreshed(CircleScreenshot screenshot) {
        if (screenshot != null) {
            this.sendMessage(screenshot.toJSONObject().toString());
        }
    }

    public void onActivityLifecycle(ActivityLifecycleEvent event) {
        if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_RESUMED) {
            this.safeTipView.show(event.getActivity());
        } else if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_PAUSED) {
            this.safeTipView.removeOnly();
        }
    }
}

