/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.view;

import android.app.Activity;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ExpandableListView;
import android.widget.TextView;
import androidx.viewpager.widget.ViewPager;
import com.growingio.android.sdk.autotrack.page.Page;
import com.growingio.android.sdk.autotrack.page.PageProvider;
import com.growingio.android.sdk.autotrack.shadow.ListMenuItemViewShadow;
import com.growingio.android.sdk.autotrack.util.ClassUtil;
import com.growingio.android.sdk.autotrack.view.ViewAttributeUtil;
import com.growingio.android.sdk.autotrack.view.ViewHelper;
import com.growingio.android.sdk.autotrack.view.ViewUtil;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.utils.ClassExistHelper;
import com.growingio.android.sdk.track.view.WindowHelper;

public class ViewNode {
    private View mView;
    private String mXPath;
    private String mOriginalXPath;
    private String mClickableParentXPath;
    private String mViewContent;
    private boolean mHasListParent;
    private String mPrefixPage;
    private int mIndex;
    private static final String INPUT = "INPUT";
    private static final String TEXT = "TEXT";
    private static final String WEB_VIEW = "WEB_VIEW";
    private static final String BUTTON = "BUTTON";
    private static final String LIST = "LIST";
    private static final String MENU_ITEM = "MENU_ITEM";

    private ViewNode() {
    }

    public View getView() {
        return this.mView;
    }

    public String getXPath() {
        return this.mXPath;
    }

    public String getClickableParentXPath() {
        return this.mClickableParentXPath;
    }

    public String getViewContent() {
        return this.mViewContent;
    }

    public String getPrefix() {
        return this.mPrefixPage;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public String getNodeType() {
        if (this.mView instanceof EditText) {
            return INPUT;
        }
        if (this.mView instanceof TextView && !(this.mView instanceof Button)) {
            return TEXT;
        }
        if (ClassExistHelper.isListView((Object)this.mView.getParent())) {
            return LIST;
        }
        if (ClassExistHelper.isWebView((Object)this.mView)) {
            return WEB_VIEW;
        }
        return BUTTON;
    }

    public ViewNode appendNode(View view) {
        if (this.mView instanceof ViewGroup) {
            return this.appendNode(view, ((ViewGroup)this.mView).indexOfChild(view));
        }
        return this;
    }

    public ViewNode appendNode(View view, int index) {
        boolean hasListParent = this.mHasListParent || ClassExistHelper.isListView((Object)view);
        return ViewNodeBuilder.newViewNode().setView(view).setIndex(hasListParent ? this.mIndex : -1).setXPath(this.mXPath).setOriginalXPath(this.mOriginalXPath).setClickableParentXPath(ViewUtil.canCircle(this.mView) ? this.mXPath : this.mClickableParentXPath).setHasListParent(hasListParent).setPrefixPage(this.mPrefixPage).setViewPosition(index).needRecalculate(true).build();
    }

    public static final class ViewNodeBuilder {
        private View mView;
        private String mXPath;
        private String mOriginalXPath;
        private String mClickableParentXPath;
        private String mViewContent;
        private boolean mHasListParent;
        private String mPrefixPage;
        private int mIndex;
        private boolean mNeedRecalculate = false;
        private int mViewPosition;

        private ViewNodeBuilder() {
        }

        public static ViewNodeBuilder newViewNode() {
            return new ViewNodeBuilder();
        }

        public ViewNodeBuilder needRecalculate(boolean needRecalculate) {
            this.mNeedRecalculate = needRecalculate;
            return this;
        }

        public ViewNodeBuilder setViewPosition(int viewPosition) {
            this.mViewPosition = viewPosition;
            return this;
        }

        public ViewNodeBuilder setView(View mView) {
            this.mView = mView;
            return this;
        }

        public ViewNodeBuilder setXPath(String mXPath) {
            this.mXPath = mXPath;
            return this;
        }

        public ViewNodeBuilder setOriginalXPath(String mOriginalXPath) {
            this.mOriginalXPath = mOriginalXPath;
            return this;
        }

        public ViewNodeBuilder setClickableParentXPath(String mClickableParentXPath) {
            this.mClickableParentXPath = mClickableParentXPath;
            return this;
        }

        public ViewNodeBuilder setViewContent(String mViewContent) {
            this.mViewContent = mViewContent;
            return this;
        }

        public ViewNodeBuilder setHasListParent(boolean hasListParent) {
            this.mHasListParent = hasListParent;
            return this;
        }

        public ViewNodeBuilder setPrefixPage(String prefixPage) {
            this.mPrefixPage = prefixPage;
            return this;
        }

        public ViewNodeBuilder setIndex(int mIndex) {
            this.mIndex = mIndex;
            return this;
        }

        public ViewNode build() {
            if (this.mNeedRecalculate) {
                this.recalculate();
            }
            ViewNode viewNode = new ViewNode();
            viewNode.mView = this.mView;
            viewNode.mXPath = this.mXPath;
            viewNode.mOriginalXPath = this.mOriginalXPath;
            viewNode.mClickableParentXPath = this.mClickableParentXPath;
            viewNode.mViewContent = this.mViewContent;
            viewNode.mHasListParent = this.mHasListParent;
            viewNode.mPrefixPage = this.mPrefixPage;
            viewNode.mIndex = this.mIndex;
            return viewNode;
        }

        private void recalculate() {
            this.calculateViewPosition();
            this.calculateViewXPath();
            this.calculateViewContent();
        }

        private void calculateViewPosition() {
            if (this.mView.getParent() != null && this.mView.getParent() instanceof ViewGroup) {
                int adapterPosition;
                ViewGroup parent = (ViewGroup)this.mView.getParent();
                if (ClassExistHelper.instanceOfAndroidXViewPager((Object)parent)) {
                    this.mViewPosition = ((ViewPager)parent).getCurrentItem();
                } else if (ClassExistHelper.instanceOfSupportViewPager((Object)parent)) {
                    this.mViewPosition = ((android.support.v4.view.ViewPager)parent).getCurrentItem();
                } else if (parent instanceof AdapterView) {
                    AdapterView listView = (AdapterView)parent;
                    this.mViewPosition = listView.getFirstVisiblePosition() + this.mViewPosition;
                } else if (ClassExistHelper.instanceOfRecyclerView((Object)parent) && (adapterPosition = ViewHelper.getChildAdapterPositionInRecyclerView(this.mView, parent)) >= 0) {
                    this.mViewPosition = adapterPosition;
                }
            }
        }

        private void calculateViewXPath() {
            MenuItem menuItem;
            ViewParent parentObject = this.mView.getParent();
            if (parentObject == null || WindowHelper.get().isDecorView(this.mView) && !(parentObject instanceof View)) {
                return;
            }
            String customId = ViewAttributeUtil.getCustomId(this.mView);
            Page<?> page = ViewAttributeUtil.getViewPage(this.mView);
            if (customId != null) {
                this.mXPath = this.mOriginalXPath = "/" + customId;
                return;
            }
            if (page != null) {
                this.mXPath = this.mOriginalXPath = "/Page";
                this.mPrefixPage = this.mOriginalXPath;
                return;
            }
            StringBuilder originalXPath = new StringBuilder(this.mOriginalXPath);
            StringBuilder xPath = new StringBuilder(this.mXPath);
            String viewName = ClassUtil.getSimpleClassName(this.mView.getClass());
            if (ListMenuItemViewShadow.isListMenuItemView(this.mView) && (menuItem = new ListMenuItemViewShadow(this.mView).getMenuItem()) != null) {
                Activity activity = ActivityStateProvider.get().getForegroundActivity();
                Page<?> itemPage = PageProvider.get().findPage(activity);
                ViewNode itemViewNode = ViewHelper.getMenuItemViewNode(itemPage, menuItem);
                this.mXPath = itemViewNode.mXPath;
                this.mIndex = itemViewNode.mIndex;
                this.mViewContent = itemViewNode.mViewContent;
                this.mOriginalXPath = itemViewNode.mOriginalXPath;
                this.mPrefixPage = itemViewNode.mOriginalXPath;
                return;
            }
            if (parentObject instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)parentObject;
                if (parent instanceof ExpandableListView) {
                    ExpandableListView listParent = (ExpandableListView)parent;
                    long elp = ((ExpandableListView)this.mView.getParent()).getExpandableListPosition(this.mViewPosition);
                    if (ExpandableListView.getPackedPositionType((long)elp) == 2) {
                        if (this.mViewPosition < listParent.getHeaderViewsCount()) {
                            originalXPath.append("/ELH[").append(this.mViewPosition).append("]/").append(viewName).append("[0]");
                            xPath.append("/ELH[").append(this.mViewPosition).append("]/").append(viewName).append("[0]");
                        } else {
                            int footerIndex = this.mViewPosition - (listParent.getCount() - listParent.getFooterViewsCount());
                            originalXPath.append("/ELF[").append(footerIndex).append("]/").append(viewName).append("[0]");
                            xPath.append("/ELF[").append(footerIndex).append("]/").append(viewName).append("[0]");
                        }
                    } else {
                        int groupIdx = ExpandableListView.getPackedPositionGroup((long)elp);
                        int childIdx = ExpandableListView.getPackedPositionChild((long)elp);
                        if (childIdx != -1) {
                            this.mIndex = childIdx;
                            xPath = new StringBuilder(originalXPath).append("/ELVG[").append(groupIdx).append("]/ELVC[-]/").append(viewName).append("[0]");
                            originalXPath.append("/ELVG[").append(groupIdx).append("]/ELVC[").append(childIdx).append("]/").append(viewName).append("[0]");
                        } else {
                            this.mIndex = groupIdx;
                            xPath = new StringBuilder(originalXPath).append("/ELVG[-]/").append(viewName).append("[0]");
                            originalXPath.append("/ELVG[").append(groupIdx).append("]/").append(viewName).append("[0]");
                        }
                    }
                } else if (ClassExistHelper.isListView((Object)parent) || ClassExistHelper.instanceOfRecyclerView((Object)parent)) {
                    this.mIndex = this.mViewPosition;
                    xPath = new StringBuilder(originalXPath).append("/").append(viewName).append("[-]");
                    originalXPath.append("/").append(viewName).append("[").append(this.mViewPosition).append("]");
                } else if (ClassExistHelper.instanceofAndroidXSwipeRefreshLayout((Object)parentObject) || ClassExistHelper.instanceOfSupportSwipeRefreshLayout((Object)parentObject)) {
                    originalXPath.append("/").append(viewName).append("[0]");
                    xPath.append("/").append(viewName).append("[0]");
                } else {
                    int matchTypePosition = 0;
                    String matchType = this.mView.getClass().getSimpleName();
                    boolean findChildView = false;
                    for (int siblingIndex = 0; siblingIndex < parent.getChildCount(); ++siblingIndex) {
                        View siblingView = parent.getChildAt(siblingIndex);
                        if (siblingView == this.mView) {
                            findChildView = true;
                            break;
                        }
                        if (!siblingView.getClass().getSimpleName().equals(matchType)) continue;
                        ++matchTypePosition;
                    }
                    if (findChildView) {
                        originalXPath.append("/").append(viewName).append("[").append(matchTypePosition).append("]");
                        xPath.append("/").append(viewName).append("[").append(matchTypePosition).append("]");
                    } else {
                        originalXPath.append("/").append(viewName).append("[").append(this.mViewPosition).append("]");
                        xPath.append("/").append(viewName).append("[").append(this.mViewPosition).append("]");
                    }
                }
            } else {
                originalXPath.append("/").append(viewName).append("[").append(this.mViewPosition).append("]");
                xPath.append("/").append(viewName).append("[").append(this.mViewPosition).append("]");
            }
            String id2 = ViewHelper.getViewPackageId(this.mView);
            if (id2 != null) {
                originalXPath.append("#").append(id2);
                xPath.append("#").append(id2);
            }
            this.mXPath = xPath.toString();
            this.mOriginalXPath = originalXPath.toString();
        }

        private void calculateViewContent() {
            this.mViewContent = ViewHelper.getViewContent(this.mView);
        }
    }
}

