/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.view;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.autotrack.IgnorePolicy;
import com.growingio.android.sdk.autotrack.page.Page;
import com.growingio.android.sdk.autotrack.page.PageProvider;
import com.growingio.android.sdk.autotrack.shadow.ListMenuItemViewShadow;
import com.growingio.android.sdk.autotrack.util.ClassUtil;
import com.growingio.android.sdk.autotrack.view.PageHelper;
import com.growingio.android.sdk.autotrack.view.ViewAttributeUtil;
import com.growingio.android.sdk.autotrack.view.ViewNode;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.utils.ActivityUtil;
import com.growingio.android.sdk.track.utils.ClassExistHelper;
import com.growingio.android.sdk.track.view.WindowHelper;
import java.util.ArrayList;
import java.util.List;

public class ViewHelper {
    private static final String TAG = "ViewHelper";
    private static final int MAX_CONTENT_LENGTH = 100;
    private static final int PACKAGE_ID_START = 0x7F000000;
    private static final String POPUP_DECOR_VIEW_CLASS_NAME = "PopupDecorView";

    private ViewHelper() {
    }

    public static boolean isViewSelfVisible(View mView) {
        if (mView == null || mView.getWindowVisibility() == 8) {
            return false;
        }
        if (WindowHelper.get().isDecorView(mView)) {
            return true;
        }
        if (mView.getWidth() <= 0 || mView.getHeight() <= 0 || !(mView.getAlpha() > 0.0f) || !mView.getLocalVisibleRect(new Rect())) {
            return false;
        }
        if (mView.getVisibility() != 0 && mView.getAnimation() != null && mView.getAnimation().getFillAfter()) {
            return true;
        }
        return mView.getVisibility() == 0;
    }

    public static boolean viewVisibilityInParents(View view) {
        if (view == null) {
            return false;
        }
        if (!ViewHelper.isViewSelfVisible(view)) {
            return false;
        }
        ViewParent viewParent = view.getParent();
        while (viewParent instanceof View) {
            if (ViewHelper.isViewSelfVisible((View)viewParent)) {
                if ((viewParent = viewParent.getParent()) != null) continue;
                Logger.d((String)TAG, (String)"Hit detached view: ", (Object[])new Object[]{viewParent});
                return false;
            }
            return false;
        }
        return true;
    }

    public static ViewNode getMenuItemViewNode(Page<?> page, MenuItem menuItem) {
        StringBuilder xpath = new StringBuilder();
        if (page.isIgnored()) {
            xpath.append("/IgnorePage");
        } else {
            xpath.append("/Page");
        }
        Context context = TrackerContext.get().getApplicationContext();
        xpath.append("/MenuView/MenuItem#").append(ViewHelper.getPackageId(context, menuItem.getItemId()));
        return ViewNode.ViewNodeBuilder.newViewNode().needRecalculate(false).setIndex(-1).setViewContent(menuItem.getTitle() != null ? menuItem.getTitle().toString() : null).setXPath(xpath.toString()).setOriginalXPath(xpath.toString()).setPrefixPage(xpath.toString()).build();
    }

    @Nullable
    public static ViewNode getClickViewNode(View view) {
        if (view == null) {
            return null;
        }
        Activity activity = ActivityStateProvider.get().getForegroundActivity();
        if (activity == null || ViewHelper.isIgnoredView(view)) {
            return null;
        }
        return ViewHelper.getViewNode(view);
    }

    @Nullable
    public static String getViewPackageId(View view) {
        return ViewHelper.getPackageId(view.getContext(), view.getId());
    }

    public static String getPackageId(Context context, int id2) {
        try {
            if (id2 <= 0x7F000000) {
                return null;
            }
            return context.getResources().getResourceEntryName(id2);
        }
        catch (Resources.NotFoundException e) {
            Logger.e((String)TAG, (Throwable)e);
            return null;
        }
    }

    private static ViewNode getViewNode(View view) {
        MenuItem menuItem;
        if (ListMenuItemViewShadow.isListMenuItemView(view) && (menuItem = new ListMenuItemViewShadow(view).getMenuItem()) != null) {
            Activity activity = ActivityStateProvider.get().getForegroundActivity();
            Page<?> page = PageProvider.get().findPage(activity);
            return ViewHelper.getMenuItemViewNode(page, menuItem);
        }
        ArrayList<View> viewTreeList = new ArrayList<View>(8);
        ViewNode viewNode = ViewHelper.getTopViewNode(view, viewTreeList);
        for (int i = viewTreeList.size() - 2; i >= 0; --i) {
            viewNode = viewNode.appendNode(viewTreeList.get(i));
        }
        return viewNode;
    }

    public static ViewNode getTopViewNode(View view, List<View> viewTreeList) {
        String xpath;
        String originalXpath;
        if (viewTreeList == null) {
            viewTreeList = new ArrayList<View>(8);
        }
        View parent = view;
        boolean findPage = false;
        do {
            if (ViewAttributeUtil.getCustomId(parent) != null) {
                viewTreeList.add(parent);
                break;
            }
            Page<?> page = ViewAttributeUtil.getViewPage(parent);
            if (page != null) {
                findPage = true;
                viewTreeList.add(parent);
                if (page.isIgnored()) continue;
                break;
            }
            if (findPage) continue;
            viewTreeList.add(parent);
        } while (parent.getParent() instanceof View && (parent = (View)parent.getParent()) instanceof ViewGroup);
        View rootView = viewTreeList.get(viewTreeList.size() - 1);
        Page<?> rootPage = ViewAttributeUtil.getViewPage(rootView);
        if (ViewAttributeUtil.getCustomId(rootView) != null) {
            xpath = originalXpath = "/" + ViewAttributeUtil.getCustomId(rootView);
        } else if (rootPage != null) {
            xpath = originalXpath = PageHelper.getWindowPrefix(rootView);
        } else {
            String prefix = PageHelper.getWindowPrefix(rootView);
            xpath = Build.VERSION.SDK_INT < 23 && prefix.equals("/PopupWindow") && !POPUP_DECOR_VIEW_CLASS_NAME.equals(ClassUtil.getSimpleClassName(rootView.getClass())) ? prefix + "/" + POPUP_DECOR_VIEW_CLASS_NAME + "/" + ClassUtil.getSimpleClassName(rootView.getClass()) + "[0]" : prefix + "/" + ClassUtil.getSimpleClassName(rootView.getClass());
            originalXpath = xpath;
        }
        return ViewNode.ViewNodeBuilder.newViewNode().setView(rootView).setIndex(-1).setViewContent(ViewHelper.getViewContent(rootView)).setXPath(xpath).setOriginalXPath(originalXpath).setPrefixPage(rootPage == null ? "" : originalXpath).build();
    }

    public static int getChildAdapterPositionInRecyclerView(View childView, ViewGroup parentView) {
        if (ClassExistHelper.instanceOfAndroidXRecyclerView((Object)parentView)) {
            return ((androidx.recyclerview.widget.RecyclerView)parentView).getChildAdapterPosition(childView);
        }
        if (ClassExistHelper.instanceOfSupportRecyclerView((Object)parentView)) {
            try {
                return ((RecyclerView)parentView).getChildAdapterPosition(childView);
            }
            catch (Throwable e) {
                return ((RecyclerView)parentView).getChildPosition(childView);
            }
        }
        return -1;
    }

    private static boolean shouldChangeOn(View view) {
        if (view instanceof EditText) {
            String tag = ViewAttributeUtil.getMonitoringFocusContent(view);
            String lastText = tag == null ? "" : tag;
            String nowText = ((EditText)view).getText().toString();
            if (TextUtils.isEmpty((CharSequence)nowText) && TextUtils.isEmpty((CharSequence)lastText) || lastText.equals(nowText)) {
                return false;
            }
            ViewAttributeUtil.setMonitoringFocusContent(view, nowText);
            return true;
        }
        return false;
    }

    @Nullable
    public static ViewNode getChangeViewNode(View view) {
        if (view == null) {
            return null;
        }
        Activity activity = ActivityUtil.findActivity((Context)view.getContext());
        if (activity == null || ViewHelper.isIgnoredView(view) || !ViewHelper.shouldChangeOn(view)) {
            return null;
        }
        return ViewHelper.getViewNode(view);
    }

    public static boolean isIgnoredView(View view) {
        IgnorePolicy ignorePolicy = ViewAttributeUtil.getIgnorePolicy(view);
        if (ignorePolicy != null) {
            return ignorePolicy == IgnorePolicy.IGNORE_SELF || ignorePolicy == IgnorePolicy.IGNORE_ALL;
        }
        return ViewHelper.isIgnoredByParent(view);
    }

    private static boolean isIgnoredByParent(View view) {
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            IgnorePolicy ignorePolicy = ViewAttributeUtil.getIgnorePolicy((View)parent);
            if (ignorePolicy == IgnorePolicy.IGNORE_ALL || ignorePolicy == IgnorePolicy.IGNORE_CHILD) {
                return true;
            }
            return ViewHelper.isIgnoredByParent((View)parent);
        }
        return false;
    }

    public static String getViewContent(View view) {
        String value = "";
        String contentTag = ViewAttributeUtil.getContent(view);
        if (contentTag != null) {
            value = contentTag;
        } else {
            if (view instanceof EditText) {
                EditText editText = (EditText)view;
                if (ViewAttributeUtil.getTrackText((View)editText) != null && !ViewHelper.isPasswordInputType(editText.getInputType())) {
                    Editable sequence = editText.getText();
                    value = sequence == null ? "" : sequence.toString();
                }
            } else if (view instanceof RatingBar) {
                value = String.valueOf(((RatingBar)view).getRating());
            } else if (view instanceof Spinner) {
                Object item = ((Spinner)view).getSelectedItem();
                if (item instanceof String) {
                    value = (String)item;
                } else {
                    View selected = ((Spinner)view).getSelectedView();
                    if (selected instanceof TextView && ((TextView)selected).getText() != null) {
                        value = ((TextView)selected).getText().toString();
                    }
                }
            } else if (view instanceof SeekBar) {
                value = String.valueOf(((SeekBar)view).getProgress());
            } else if (view instanceof RadioGroup) {
                RadioGroup group = (RadioGroup)view;
                View selected = group.findViewById(group.getCheckedRadioButtonId());
                if (selected instanceof RadioButton && ((RadioButton)selected).getText() != null) {
                    value = ((RadioButton)selected).getText().toString();
                }
            } else if (view instanceof TextView && ((TextView)view).getText() != null) {
                value = ((TextView)view).getText().toString();
            }
            if (TextUtils.isEmpty((CharSequence)value) && view.getContentDescription() != null) {
                value = view.getContentDescription().toString();
            }
        }
        return ViewHelper.truncateViewContent(value);
    }

    public static String truncateViewContent(String value) {
        if (value == null) {
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)value) && value.length() > 100) {
            value = value.substring(0, 100);
        }
        return value;
    }

    @TargetApi(value=11)
    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18 || variation == 145;
    }
}

