/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.view;

import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.growingio.android.sdk.autotrack.page.Page;
import com.growingio.android.sdk.autotrack.view.ViewAttributeUtil;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;

class PageHelper {
    public static final String PAGE_PREFIX = "/Page";
    public static final String IGNORE_PAGE_PREFIX = "/IgnorePage";
    public static final String MAIN_WINDOW_PREFIX = "/MainWindow";
    public static final String DIALOG_WINDOW_PREFIX = "/DialogWindow";
    public static final String POPUP_WINDOW_PREFIX = "/PopupWindow";
    public static final String CUSTOM_WINDOW_PREFIX = "/CustomWindow";

    private PageHelper() {
    }

    static String getMainWindowPrefix() {
        return MAIN_WINDOW_PREFIX;
    }

    static String getWindowPrefix(View root) {
        Page<?> page = ViewAttributeUtil.getViewPage(root);
        String windowPrefix = page != null ? (page.isIgnored() ? IGNORE_PAGE_PREFIX : PAGE_PREFIX) : (root.hashCode() == ActivityStateProvider.get().getCurrentRootWindowsHashCode() ? PageHelper.getMainWindowPrefix() : PageHelper.getSubWindowPrefix(root));
        return windowPrefix;
    }

    private static String getSubWindowPrefix(View root) {
        ViewGroup.LayoutParams params = root.getLayoutParams();
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams windowParams = (WindowManager.LayoutParams)params;
            int type = windowParams.type;
            if (type == 1) {
                return MAIN_WINDOW_PREFIX;
            }
            if (type < 99) {
                return DIALOG_WINDOW_PREFIX;
            }
            if (type < 1999) {
                return POPUP_WINDOW_PREFIX;
            }
        }
        return CUSTOM_WINDOW_PREFIX;
    }
}

