/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.shadow;

import android.annotation.SuppressLint;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.view.menu.ListMenuItemView;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.utils.ClassExistHelper;
import java.lang.reflect.Method;

public class ListMenuItemViewShadow {
    private static final String TAG = "ListMenuItemViewShadow";
    private static Class<?> sListMenuItemViewClazz;
    private static Method sItemViewGetDataMethod;
    private final View mView;

    public ListMenuItemViewShadow(View view) {
        this.mView = view;
    }

    public static boolean isListMenuItemView(View view) {
        return view.getClass() == sListMenuItemViewClazz || ClassExistHelper.instanceOfSupportListMenuItemView((Object)view) || ClassExistHelper.instanceOfAndroidXListMenuItemView((Object)view);
    }

    @SuppressLint(value={"RestrictedApi"})
    @Nullable
    public MenuItem getMenuItem() {
        View view = this.mView;
        if (view == null) {
            return null;
        }
        if (view.getClass() == sListMenuItemViewClazz) {
            try {
                return (MenuItem)sItemViewGetDataMethod.invoke((Object)view, new Object[0]);
            }
            catch (Exception e) {
                Logger.e((String)TAG, (Throwable)e);
            }
        } else {
            if (ClassExistHelper.instanceOfAndroidXListMenuItemView((Object)view)) {
                return ((ListMenuItemView)view).getItemData();
            }
            if (ClassExistHelper.instanceOfSupportListMenuItemView((Object)view)) {
                return ((android.support.v7.view.menu.ListMenuItemView)view).getItemData();
            }
        }
        return null;
    }

    static {
        try {
            sListMenuItemViewClazz = Class.forName("com.android.internal.view.menu.ListMenuItemView");
            Class<?> itemViewInterface = Class.forName("com.android.internal.view.menu.MenuView$ItemView");
            sItemViewGetDataMethod = itemViewInterface.getDeclaredMethod("getItemData", new Class[0]);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (Throwable)e);
        }
    }
}

