/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.page;

import android.app.Activity;
import android.app.Fragment;
import android.content.res.Resources;
import android.view.View;
import androidx.annotation.Nullable;

public abstract class SuperFragment<T> {
    private final T mRealFragment;

    protected SuperFragment(T realFragment) {
        this.mRealFragment = realFragment;
    }

    @Nullable
    public static SuperFragment<Fragment> make(Fragment fragment) {
        if (fragment == null) {
            return null;
        }
        return new SystemFragment(fragment);
    }

    @Nullable
    public static SuperFragment<android.support.v4.app.Fragment> makeSupport(android.support.v4.app.Fragment fragment) {
        if (fragment == null) {
            return null;
        }
        return new V4Fragment(fragment);
    }

    @Nullable
    public static SuperFragment<androidx.fragment.app.Fragment> makeX(androidx.fragment.app.Fragment fragment) {
        if (fragment == null) {
            return null;
        }
        return new AndroidXFragment(fragment);
    }

    public T getRealFragment() {
        return this.mRealFragment;
    }

    public abstract int getId();

    public abstract String getTag();

    public abstract View getView();

    public abstract Resources getResources();

    public abstract Activity getActivity();

    public abstract SuperFragment<T> getParentFragment();

    public abstract boolean getUserVisibleHint();

    public abstract boolean isResumed();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuperFragment that = (SuperFragment)o;
        return this.mRealFragment != null ? this.mRealFragment.equals(that.mRealFragment) : that.mRealFragment == null;
    }

    public int hashCode() {
        return this.mRealFragment != null ? this.mRealFragment.hashCode() : 0;
    }

    public abstract boolean isHidden();

    private static class AndroidXFragment
    extends SuperFragment<androidx.fragment.app.Fragment> {
        protected AndroidXFragment(androidx.fragment.app.Fragment realFragment) {
            super(realFragment);
        }

        @Override
        public int getId() {
            return ((androidx.fragment.app.Fragment)this.getRealFragment()).getId();
        }

        @Override
        public String getTag() {
            return ((androidx.fragment.app.Fragment)this.getRealFragment()).getTag();
        }

        @Override
        public View getView() {
            return ((androidx.fragment.app.Fragment)this.getRealFragment()).getView();
        }

        @Override
        public Resources getResources() {
            return ((androidx.fragment.app.Fragment)this.getRealFragment()).getResources();
        }

        @Override
        public Activity getActivity() {
            return ((androidx.fragment.app.Fragment)this.getRealFragment()).getActivity();
        }

        @Override
        @Nullable
        public SuperFragment<androidx.fragment.app.Fragment> getParentFragment() {
            return AndroidXFragment.makeX(((androidx.fragment.app.Fragment)this.getRealFragment()).getParentFragment());
        }

        @Override
        public boolean getUserVisibleHint() {
            return ((androidx.fragment.app.Fragment)this.getRealFragment()).getUserVisibleHint();
        }

        @Override
        public boolean isResumed() {
            return ((androidx.fragment.app.Fragment)this.getRealFragment()).isResumed();
        }

        @Override
        public boolean isHidden() {
            return ((androidx.fragment.app.Fragment)this.getRealFragment()).isHidden();
        }
    }

    private static class V4Fragment
    extends SuperFragment<android.support.v4.app.Fragment> {
        protected V4Fragment(android.support.v4.app.Fragment realFragment) {
            super(realFragment);
        }

        @Override
        public int getId() {
            return ((android.support.v4.app.Fragment)this.getRealFragment()).getId();
        }

        @Override
        public String getTag() {
            return ((android.support.v4.app.Fragment)this.getRealFragment()).getTag();
        }

        @Override
        public View getView() {
            return ((android.support.v4.app.Fragment)this.getRealFragment()).getView();
        }

        @Override
        public Resources getResources() {
            return ((android.support.v4.app.Fragment)this.getRealFragment()).getResources();
        }

        @Override
        public Activity getActivity() {
            return ((android.support.v4.app.Fragment)this.getRealFragment()).getActivity();
        }

        @Override
        public SuperFragment<android.support.v4.app.Fragment> getParentFragment() {
            return V4Fragment.makeSupport(((android.support.v4.app.Fragment)this.getRealFragment()).getParentFragment());
        }

        @Override
        public boolean getUserVisibleHint() {
            return ((android.support.v4.app.Fragment)this.getRealFragment()).getUserVisibleHint();
        }

        @Override
        public boolean isResumed() {
            return ((android.support.v4.app.Fragment)this.getRealFragment()).isResumed();
        }

        @Override
        public boolean isHidden() {
            return ((android.support.v4.app.Fragment)this.getRealFragment()).isHidden();
        }
    }

    private static class SystemFragment
    extends SuperFragment<Fragment> {
        protected SystemFragment(Fragment realFragment) {
            super(realFragment);
        }

        @Override
        public int getId() {
            return ((Fragment)this.getRealFragment()).getId();
        }

        @Override
        public String getTag() {
            return ((Fragment)this.getRealFragment()).getTag();
        }

        @Override
        public View getView() {
            return ((Fragment)this.getRealFragment()).getView();
        }

        @Override
        public Resources getResources() {
            return ((Fragment)this.getRealFragment()).getResources();
        }

        @Override
        public Activity getActivity() {
            return ((Fragment)this.getRealFragment()).getActivity();
        }

        @Override
        public SuperFragment<Fragment> getParentFragment() {
            return SystemFragment.make(((Fragment)this.getRealFragment()).getParentFragment());
        }

        @Override
        public boolean getUserVisibleHint() {
            return ((Fragment)this.getRealFragment()).getUserVisibleHint();
        }

        @Override
        public boolean isResumed() {
            return ((Fragment)this.getRealFragment()).isResumed();
        }

        @Override
        public boolean isHidden() {
            return ((Fragment)this.getRealFragment()).isHidden();
        }
    }
}

