/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.autotrack.page;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.UiThread;
import android.text.TextUtils;
import android.view.View;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.autotrack.IgnorePolicy;
import com.growingio.android.sdk.autotrack.page.ActivityPage;
import com.growingio.android.sdk.autotrack.page.FragmentPage;
import com.growingio.android.sdk.autotrack.page.Page;
import com.growingio.android.sdk.autotrack.page.SuperFragment;
import com.growingio.android.sdk.autotrack.view.ViewAttributeUtil;
import com.growingio.android.sdk.track.TrackMainThread;
import com.growingio.android.sdk.track.events.PageAttributesEvent;
import com.growingio.android.sdk.track.events.PageEvent;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.listener.IActivityLifecycle;
import com.growingio.android.sdk.track.listener.event.ActivityLifecycleEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.utils.ActivityUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class PageProvider
implements IActivityLifecycle {
    private static final String TAG = "PageProvider";
    private static final Map<Activity, ActivityPage> ALL_PAGE_TREE = new WeakHashMap<Activity, ActivityPage>();
    private static final Map<Object, String> ALL_PAGE_ALIAS = new WeakHashMap<Object, String>();
    private static final Map<Class<?>, IgnorePolicy> IGNORE_PAGE_CLASSES = new HashMap();
    private static final Map<Object, IgnorePolicy> IGNORE_PAGES = new WeakHashMap<Object, IgnorePolicy>();
    private static final Map<Object, Map<String, String>> PAGE_ATTRIBUTES_CACHE = new WeakHashMap<Object, Map<String, String>>();

    private PageProvider() {
    }

    public static PageProvider get() {
        return SingleInstance.INSTANCE;
    }

    public void setup() {
        ActivityStateProvider.get().registerActivityLifecycleListener((IActivityLifecycle)this);
    }

    public void addIgnoreActivity(Activity activity, IgnorePolicy policy) {
        IGNORE_PAGES.put(activity, policy);
    }

    public void addIgnoreFragment(SuperFragment<?> fragment, IgnorePolicy policy) {
        IGNORE_PAGES.put(fragment.getRealFragment(), policy);
    }

    public void onActivityLifecycle(ActivityLifecycleEvent event) {
        Activity activity = event.getActivity();
        if (activity == null) {
            return;
        }
        if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_RESUMED) {
            this.createOrResumePage(activity);
        } else if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_DESTROYED) {
            this.removePage(activity);
        }
    }

    public void addIgnorePageClass(Class<?> pageClazz, IgnorePolicy policy) {
        IGNORE_PAGE_CLASSES.put(pageClazz, policy);
    }

    @UiThread
    private void createOrResumePage(Activity activity) {
        ActivityPage page = ALL_PAGE_TREE.get(activity);
        if (page == null) {
            page = new ActivityPage(activity);
            if (!TextUtils.isEmpty((CharSequence)activity.getTitle())) {
                page.setTitle(activity.getTitle().toString());
            }
            this.addPageAlias(page);
            ViewAttributeUtil.setViewPage(activity.getWindow().getDecorView(), page);
            ALL_PAGE_TREE.put(activity, page);
        } else {
            page.refreshShowTimestamp();
        }
        this.sendPage((Context)activity, page);
    }

    private void refreshPages(Context context, Page<?> page) {
        page.refreshShowTimestamp();
        Logger.d((String)TAG, (String)("refreshPages: " + page.path()), (Object[])new Object[0]);
        this.sendPage(context, page);
        if (!page.getAllChildren().isEmpty()) {
            for (Page<?> child : page.getAllChildren()) {
                this.refreshPages(context, child);
            }
        }
    }

    private void sendPage(Context context, Page<?> page) {
        if (page.getCarrier() instanceof Activity) {
            page.setIgnored(this.isIgnoreActivity((Activity)page.getCarrier()));
        } else if (page.getCarrier() instanceof SuperFragment) {
            page.setIgnored(this.isIgnoreFragment((SuperFragment)page.getCarrier()));
        }
        if (!page.isIgnored()) {
            Logger.d((String)TAG, (String)("sendPage: path = " + page.path()), (Object[])new Object[0]);
            this.generatePageEvent(context, page);
            this.reissuePageAttributes(page);
        } else {
            Logger.e((String)TAG, (String)("sendPage: path = " + page.path() + " is ignored"), (Object[])new Object[0]);
        }
    }

    private void generatePageEvent(Context context, Page<?> page) {
        String orientation = context.getResources().getConfiguration().orientation == 1 ? "PORTRAIT" : "LANDSCAPE";
        TrackMainThread.trackMain().postEventToTrackMain((BaseEvent.BaseBuilder)new PageEvent.Builder().setPath(page.path()).setTitle(page.getTitle()).setTimestamp(page.getShowTimestamp()).setOrientation(orientation));
    }

    public void setActivityAlias(Activity activity, String alias) {
        if (TextUtils.isEmpty((CharSequence)alias)) {
            return;
        }
        ALL_PAGE_ALIAS.put(activity, alias);
    }

    public void setFragmentAlias(SuperFragment<?> fragment, String alias) {
        if (TextUtils.isEmpty((CharSequence)alias)) {
            return;
        }
        ALL_PAGE_ALIAS.put(fragment.getRealFragment(), alias);
    }

    private void addPageAlias(Page<?> page) {
        String alias = null;
        if (page.getCarrier() instanceof Activity) {
            alias = ALL_PAGE_ALIAS.get(page.getCarrier());
        } else if (page.getCarrier() instanceof SuperFragment) {
            alias = ALL_PAGE_ALIAS.get(((SuperFragment)page.getCarrier()).getRealFragment());
        }
        if (!TextUtils.isEmpty((CharSequence)alias)) {
            page.setAlias(alias);
        }
    }

    private boolean isIgnoreActivity(Activity activity) {
        IgnorePolicy ignorePolicy = IGNORE_PAGES.get(activity);
        if (ignorePolicy != null) {
            return ignorePolicy == IgnorePolicy.IGNORE_SELF || ignorePolicy == IgnorePolicy.IGNORE_ALL;
        }
        return false;
    }

    private boolean isIgnoreFragment(SuperFragment<?> fragment) {
        IgnorePolicy ignorePolicy = IGNORE_PAGES.get(fragment.getRealFragment());
        if (ignorePolicy != null) {
            return ignorePolicy == IgnorePolicy.IGNORE_SELF || ignorePolicy == IgnorePolicy.IGNORE_ALL;
        }
        return this.isIgnoreByParent(fragment);
    }

    private boolean isIgnoreByParent(SuperFragment<?> fragment) {
        IgnorePolicy ignorePolicy;
        for (SuperFragment<?> parentFragment = fragment.getParentFragment(); parentFragment != null; parentFragment = parentFragment.getParentFragment()) {
            ignorePolicy = IGNORE_PAGES.get(parentFragment.getRealFragment());
            if (ignorePolicy != IgnorePolicy.IGNORE_ALL && ignorePolicy != IgnorePolicy.IGNORE_CHILD) continue;
            return true;
        }
        ignorePolicy = IGNORE_PAGES.get(fragment.getActivity());
        return ignorePolicy == IgnorePolicy.IGNORE_ALL || ignorePolicy == IgnorePolicy.IGNORE_CHILD;
    }

    @UiThread
    private void removePage(Activity activity) {
        Logger.d((String)TAG, (String)("removePage: activity is " + activity), (Object[])new Object[0]);
        ALL_PAGE_TREE.remove(activity);
        PAGE_ATTRIBUTES_CACHE.remove(activity);
    }

    private boolean isHidden(SuperFragment<?> fragment) {
        if (fragment.isHidden()) {
            return true;
        }
        for (SuperFragment<?> parentFragment = fragment.getParentFragment(); parentFragment != null; parentFragment = parentFragment.getParentFragment()) {
            if (!parentFragment.isHidden()) continue;
            return true;
        }
        return false;
    }

    @UiThread
    public void fragmentOnHiddenChanged(SuperFragment<?> fragment, boolean hidden) {
        if (!TrackerContext.initializedSuccessfully()) {
            Logger.e((String)TAG, (String)"Autotracker do not initialized successfully", (Object[])new Object[0]);
            return;
        }
        if (!hidden) {
            Page<?> page = this.findPage(fragment);
            if (page == null) {
                Logger.e((String)TAG, (String)"fragmentOnHiddenChanged: fragment is NULL", (Object[])new Object[0]);
            } else {
                this.refreshPages((Context)fragment.getActivity(), page);
            }
        }
    }

    @UiThread
    public void createOrResumePage(SuperFragment<?> fragment) {
        if (!TrackerContext.initializedSuccessfully()) {
            Logger.e((String)TAG, (String)"Autotracker do not initialized successfully", (Object[])new Object[0]);
            return;
        }
        if (fragment == null) {
            Logger.e((String)TAG, (String)"createOrResumePage: this fragment can not make superFragment", (Object[])new Object[0]);
            return;
        }
        if (fragment.getView() == null) {
            Logger.e((String)TAG, (String)"createOrResumePage: this fragment getView is NULL", (Object[])new Object[0]);
            return;
        }
        if (this.isHidden(fragment)) {
            Logger.e((String)TAG, (String)"createOrResumePage: this fragment is hidden", (Object[])new Object[0]);
            return;
        }
        if (!fragment.getUserVisibleHint()) {
            Logger.e((String)TAG, (String)"createOrResumePage: this fragment's UI is currently invisible to the user", (Object[])new Object[0]);
            return;
        }
        if (fragment.getActivity() == null) {
            Logger.e((String)TAG, (String)"createOrResumePage: this fragment getActivity is NULL", (Object[])new Object[0]);
            return;
        }
        if (!fragment.isResumed()) {
            Logger.e((String)TAG, (String)"createOrResumePage: this fragment not is resumed", (Object[])new Object[0]);
            return;
        }
        FragmentPage page = this.findPage(fragment);
        if (page == null) {
            page = new FragmentPage(fragment);
            Page<?> pageParent = this.findPageParent(fragment);
            if (pageParent == null) {
                Logger.e((String)TAG, (String)"pageParent is NULL", (Object[])new Object[0]);
                return;
            }
            page.assignParent(pageParent);
            pageParent.addChildren(page);
            this.addPageAlias(page);
            ViewAttributeUtil.setViewPage(fragment.getView(), page);
        } else {
            page.refreshShowTimestamp();
        }
        this.sendPage((Context)fragment.getActivity(), page);
    }

    @UiThread
    public void removePage(SuperFragment<?> fragment) {
        if (!TrackerContext.initializedSuccessfully()) {
            Logger.e((String)TAG, (String)"Autotracker do not initialized successfully", (Object[])new Object[0]);
            return;
        }
        if (fragment == null) {
            Logger.e((String)TAG, (String)"removePage: this fragment can not make superFragment", (Object[])new Object[0]);
            return;
        }
        if (fragment.getView() == null) {
            Logger.e((String)TAG, (String)"removePage: this fragment getView is NULL", (Object[])new Object[0]);
            return;
        }
        Logger.e((String)TAG, (String)("removePage: fragment is " + fragment.getRealFragment()), (Object[])new Object[0]);
        PAGE_ATTRIBUTES_CACHE.remove(fragment.getRealFragment());
        Page page = ALL_PAGE_TREE.get(fragment.getActivity());
        if (page == null) {
            return;
        }
        this.removePage(fragment, page);
    }

    private void removePage(SuperFragment<?> carrier, Page<?> page) {
        List<Page<?>> pages = page.getAllChildren();
        for (int i = pages.size() - 1; i >= 0; --i) {
            Page<?> onePage = pages.get(i);
            if (carrier.equals(onePage.getCarrier())) {
                pages.remove(i);
                return;
            }
            this.removePage(carrier, onePage);
        }
    }

    private Page<?> findPageParent(SuperFragment<?> fragment) {
        Page pageParent = null;
        SuperFragment<?> parentFragment = fragment.getParentFragment();
        ActivityPage activityPage = ALL_PAGE_TREE.get(fragment.getActivity());
        if (parentFragment == null) {
            pageParent = activityPage;
        } else if (activityPage != null) {
            pageParent = this.findPage(parentFragment, activityPage);
        }
        return pageParent;
    }

    protected Page<?> findPage(SuperFragment<?> carrier) {
        Activity activity = carrier.getActivity();
        Page page = ALL_PAGE_TREE.get(activity);
        if (page == null) {
            return null;
        }
        return this.findPage(carrier, page);
    }

    private Page<?> findPage(SuperFragment<?> carrier, Page<?> page) {
        if (carrier.equals(page.getCarrier())) {
            return page;
        }
        List<Page<?>> pages = page.getAllChildren();
        for (Page<?> onePage : pages) {
            Page<?> p;
            if (onePage == null || (p = this.findPage(carrier, onePage)) == null) continue;
            return p;
        }
        return null;
    }

    private void reissuePageAttributes(Page<?> page) {
        Map<String, String> attributes = null;
        if (page.getCarrier() instanceof Activity) {
            attributes = PAGE_ATTRIBUTES_CACHE.remove(page.getCarrier());
        } else if (page.getCarrier() instanceof SuperFragment) {
            attributes = PAGE_ATTRIBUTES_CACHE.remove(((SuperFragment)page.getCarrier()).getRealFragment());
        }
        if (attributes != null) {
            this.setPageAttributes(page, attributes, false);
            return;
        }
        attributes = page.getAttributes();
        if (attributes != null) {
            this.setPageAttributes(page, attributes, false);
            return;
        }
        if (page.getParent() != null && (attributes = page.getParent().getAttributes()) != null) {
            this.setPageAttributes(page, attributes, false);
        }
    }

    public void setPageAttributes(Activity activity, Map<String, String> attributes) {
        ActivityPage page = ALL_PAGE_TREE.get(activity);
        if (page != null) {
            this.setPageAttributes(page, attributes, true);
        } else {
            Logger.e((String)TAG, (String)("setPageAttributes: can't find Activity " + activity), (Object[])new Object[0]);
            PAGE_ATTRIBUTES_CACHE.put(activity, attributes);
        }
    }

    public void setPageAttributes(SuperFragment<?> fragment, Map<String, String> attributes) {
        Page<?> page = this.findPage(fragment);
        if (page != null) {
            this.setPageAttributes(page, attributes, true);
        } else {
            Logger.e((String)TAG, (String)("setPageAttributes: can't find Fragment " + fragment.getRealFragment()), (Object[])new Object[0]);
            PAGE_ATTRIBUTES_CACHE.put(fragment.getRealFragment(), attributes);
        }
    }

    private void setPageAttributes(Page<?> page, Map<String, String> attributes, boolean checkEquals) {
        if (checkEquals && attributes.equals(page.getAttributes())) {
            Logger.e((String)TAG, (String)"setPageAttributes is equals page.getAttributes", (Object[])new Object[0]);
            return;
        }
        page.setAttributes(attributes);
        if (!page.isIgnored()) {
            Logger.d((String)TAG, (String)("setPageAttributes: page = " + page.path() + ", attributes = " + attributes.toString()), (Object[])new Object[0]);
            this.generatePageAttributesEvent(page);
        }
        if (!page.getAllChildren().isEmpty()) {
            for (Page<?> child : page.getAllChildren()) {
                if (child.getShowTimestamp() < page.getShowTimestamp()) continue;
                this.setPageAttributes(child, attributes, checkEquals);
            }
        }
    }

    private void generatePageAttributesEvent(Page<?> page) {
        TrackMainThread.trackMain().postEventToTrackMain((BaseEvent.BaseBuilder)new PageAttributesEvent.Builder().setPath(page.path()).setPageShowTimestamp(page.getShowTimestamp()).setAttributes(page.getAttributes()));
    }

    public Page<?> findPage(Activity activity) {
        return ALL_PAGE_TREE.get(activity);
    }

    public Page<?> findPage(View view) {
        Page<?> page = ViewAttributeUtil.getViewPage(view);
        if (page != null && (!page.isIgnored() || page instanceof ActivityPage)) {
            return page;
        }
        if (view.getParent() instanceof View) {
            return this.findPage((View)view.getParent());
        }
        Context viewContext = view.getContext();
        Activity activity = ActivityUtil.findActivity((Context)viewContext);
        if (activity == null) {
            activity = ActivityStateProvider.get().getForegroundActivity();
        }
        if (activity != null) {
            if (ALL_PAGE_TREE.containsKey(activity)) {
                return ALL_PAGE_TREE.get(activity);
            }
            ActivityPage newPage = new ActivityPage(activity);
            newPage.setTitle(activity.getTitle().toString());
            return newPage;
        }
        throw new NullPointerException("Page is NULL");
    }

    private static class SingleInstance {
        private static final PageProvider INSTANCE = new PageProvider();

        private SingleInstance() {
        }
    }
}

